/***************************************************************************
                             toolbartabwidget.h
                             ---------------------
    copyright            : (C) 2003 by Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef TOOLBARTABWIDGET_H
#define TOOLBARTABWIDGET_H

#include <tqwidget.h>
#include <tqmap.h>

class TQTabWidget;
class KPopupMenu;
class TQWidgetStack;
class TQTabBar;
class KToolBar;

class ToolbarTabWidget: public QTabWidget
{
  Q_OBJECT
public:
  TQWidgetStack *m_widgetStack;

  static ToolbarTabWidget* const ref(TQWidget *parent = 0L, const char *name = 0L)
  {
    static ToolbarTabWidget *m_ref;
    if (!m_ref) m_ref = new ToolbarTabWidget (parent, name);
    return m_ref;
  }
  virtual ~ToolbarTabWidget(){};

  virtual void insertTab(TQWidget *child, const TQString &label, const TQString &id);
  virtual TQWidget* page(int index);
  virtual TQWidget* page(const TQString& id);
  int tabHeight() const;
  TQString id(TQWidget *w) const;
  TQString id(int index) const;
  KToolBar::IconText iconText() const {return m_iconText;}
  void setIconText(KToolBar::IconText mode) {m_iconText = mode; emit iconTextModeChanged();}

public slots:
  virtual void removePage(TQWidget * w );
  virtual void resizeEvent(TQResizeEvent *);

private slots:
  void slotRemoveToolbar();
  void slotRenameToolbar();
  void slotEditToolbar();

signals:
  void removeToolbar(const TQString&);
  void renameToolbar(const TQString&);
  void editToolbar(const TQString&);
  void newAction();
  void addToolbar();
  void iconTextModeChanged();

public:
  TQString tabUnderMouse;
  TQString tabUnderMouseLabel;

protected:
  virtual void mousePressEvent ( TQMouseEvent * e );

  KPopupMenu *m_popupMenu;
  TQTabBar *m_tabBar;
  TQMap<TQString, TQWidget*> toolbarList;

private:
  ToolbarTabWidget(TQWidget * parent = 0, const char * name = 0, WFlags f = 0);
  KToolBar::IconText m_iconText;

};

class QuantaToolBar: public KToolBar
{
  Q_OBJECT

public:
  QuantaToolBar (TQWidget *parent, const char *name=0, bool honor_style=FALSE, bool readConfig=TRUE);
  virtual ~QuantaToolBar() {};

private slots:
  void slotEditAction();
  void slotRemoveAction();
  void slotIconTextChanged(int id);
  void slotIconTextMenuAboutToShow();

signals:
  void removeAction(const TQString&, const TQString&);
  void editAction(const TQString&);

protected:
  virtual void mousePressEvent ( TQMouseEvent * e );

  KPopupMenu *m_popupMenu;
  KPopupMenu *m_iconTextMenu;
  ToolbarTabWidget *m_toolbarTab;
  TQString currentActionName;
};

#endif
