/***************************************************************************
                          doctreeview.h  -  description
                             -------------------
    begin                : Sat Mar 4 2000
    copyright            : (C) 2000 by Yacovlev Alexander & Dmitry Poplavsky <pdima@mail.univ.kiev.ua>
                           (C) 2002, 2004 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DOCTREEVIEW_H
#define DOCTREEVIEW_H

//qt includes
#include <tqdict.h>
#include <tqvaluelist.h>

//kde includes
#include <klistview.h>

class DocFolder;
class KPopupMenu;


/**
  *@author Yacovlev Alexander & Dmitry Poplavsky
  */

class DocTreeView : public KListView  {
   Q_OBJECT
public:
  DocTreeView(TQWidget *parent=0, const char *name=0);
  ~DocTreeView();

  TQString *contextHelp(const TQString &keyword);

public slots:
  void slotNewProjectLoaded(const TQString &, const KURL &, const KURL &);
  void slotReloadProjectDocs();
  void slotAddProjectDoc(const KURL& url);
  /** Re-reads the documentation directories. */
  void slotRefreshTree();

signals:
  void openURL(const TQString& );
  void reloadProjectDocs();
  void downloadDoc();

private slots:
  void clickItem( TQListViewItem *);
  void slotDoubleClicked(TQListViewItem *);
  void slotMenu(KListView *, TQListViewItem *item, const TQPoint &point);


private:

  TQDict<TQString> *contextHelpDict;
  TQValueList<DocFolder *> m_folderList;
  KListViewItem *projectDocFolder;
  KPopupMenu *m_contextMenu;
  int m_menuReload;
};

#endif
