/***************************************************************************
                          dtdparser.h  -  description
                             -------------------
    begin                : Sun Oct 19 16:47:20 EEST 2003
    copyright            : (C) 2003 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/
#ifndef DTDPARSER_H
#define DTDPARSER_H

//qt includes
#include <tqdict.h>

//forward declarations
class KURL;
class TQString;
struct Attribute;

/** libxml2 based XML DTD parser and DTEP creation class*/
class DTDParser {
public:
  DTDParser(const KURL& dtdURL, const TQString &dtepDir);
  ~DTDParser();
  TQString dirName();
  /**
   * Parse the DTD file.
   * @param targetDir the directory of the destination DTEP. If empty, a dialog is shown to configure the destination.
   * @param entitiesOnly if true, only the entities are extracted from the DTD into the entities.tag file 
   * @return true on success, false if some error happened
   */
  bool parse(const TQString &targetDir = TQString::null, bool entitiesOnly = false);

protected:
  void writeDescriptionRC();

private:
  KURL m_dtdURL;
  TQString m_dtepDir;
  TQString m_name;
  TQString m_nickName;
  TQString m_doctype;
  TQString m_dtdURLLine;
  bool m_caseSensitive;
  TQString m_defaultExtension;
  TQDict<Attribute> m_tags;
};

#endif
