/***************************************************************************
                          dtdparser.cpp  -  description
                             -------------------
    begin                : Tue Jul 30 15:26:20 EEST 2002
    copyright            : (C) 2002 by Jason P. Hanley <jphanley@buffalo.edu>
                           (C) 2002, 2003 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DTD_H
#define DTD_H

//qt includes
#include <tqdict.h>

//app includes
#include "qtag.h"

class KURL;

class DTD
{

public:
  DTD(const KURL &dtdURL, const TQString& dtepDir);
  ~DTD();

public:
  TQStringList getTags();
  AttributeList* getTagAttributes(TQString tag);
  TQStringList getTextCompletion(TQString tag);
  void printContents();
  void writeTagFiles();
  /** No descriptions */
  bool parseDTD();

private:
  bool parseDTD(const KURL& url);
  void parseDTDEntity(const TQString &line);
  void parseDTDElement(const TQString &line);
  void parseDTDAttlist(const TQString &line);
  void parseTagAttributeValues(const TQString &name, TQString *value);
  void parseDTDReplace(TQString *value);
  void stripSpaces(TQString *value);
  void removeComments(TQString &value);

  TQDict<TQString> entities;
  TQDict<TQString> elements;
  TQStringList tags;
  TQDict<AttributeList> tagAttributes;
  /** From where to load the DTD file. */
  KURL m_dtdURL;
  TQString m_dtepDir;
};

#endif
