//
// C++ Interface: annotationoutput
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kde.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef ANNOTATIONOUTPUT_H
#define ANNOTATIONOUTPUT_H

#include <kurl.h>
#include <ktabwidget.h>

/**
@author Andras Mantia
*/

class TQDomDocument;
class TQListViewItem;
class TQTimer;

class KListView;
class KListViewItem;

class MessageOutput;

enum AnnotationScope
{
  CurrentFile = 0,
  AllFiles
};

class AnnotationOutput : public KTabWidget
{
Q_OBJECT
public:
    AnnotationOutput(TQWidget *parent = 0, const char *name = 0);

    ~AnnotationOutput();
    MessageOutput *currentFileAnnotations() const {return m_currentFileAnnotations;}
    KListView *allAnnotations() const {return m_allAnnotations;}
    void writeAnnotations(const TQString &fileName, const TQMap<uint, QPair<TQString, TQString> > &annotations);

public slots:
    /**
     * Scans the project files to see if there were annotations added or modified outside of Quanta. The scan is done in background.
     */
    void updateAnnotations();
    void readAnnotations(); 
    void clearAnnotations();
    void insertAnnotation(uint line, const TQString& fileName, const QPair<TQString, TQString>& annotation);

private slots:
    void tabChanged(TQWidget *w);
    void allAnnotationsItemExecuted(TQListViewItem *item);
    void yourAnnotationsItemExecuted(TQListViewItem *item);
    void slotUpdateNextFile();

signals:
    void clicked(const TQString& fname, int line, int col);

private:
    /**
     * Updates the annotation for a file.
     * @param url 
     */
    void updateAnnotationForFile(const KURL& url);

    MessageOutput *m_currentFileAnnotations;
    KListView *m_allAnnotations;
    TQDict<KListViewItem> m_annotatedFileItems;
    TQMap<TQListViewItem*, TQString> m_fileNames;
    TQMap<TQListViewItem*, uint> m_lines;
    uint m_yourAnnotationsNum;

    KListView *m_yourAnnotations;
    TQDict<KListViewItem> m_yourFileItems;
    TQMap<TQListViewItem*, TQString> m_yourFileNames;
    TQMap<TQListViewItem*, uint> m_yourLines;

    TQTimer *m_updateTimer;
    KURL::List m_files;
    uint m_fileIndex;
};

#endif
