/***************************************************************************
                          tagxml.h  -  description
                             -------------------
    begin                : ����25 14:34:07 EEST 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev <pdima@users.sourceforge.net,yshurik@linuxfan.com>
                           (C) 2004 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGATTR_H
#define TAGATTR_H

//qt includes
#include <tqstring.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqdom.h>

//kde includes
#include <klineedit.h>
#include <kurl.h>

//app includes
#include "colorcombo.h"
#include "filecombo.h"

class TQDomElement;
class TQWidget;
class QTag;


TQDomNode findChild( TQDomNode &parent, const TQString &name );


class Attr
{
  public:
    Attr( TQDomElement const& el, TQWidget *, QTag *dtdTag )
    : domEl(el), name(domEl.attribute("name","")), m_dtdTag(dtdTag) {}
    //{ domEl = el; name = domEl->attribute("name",""); m_dtdTag = dtdTag;}
    virtual ~Attr(){}

    virtual TQString value()=0;
    virtual void setValue(const TQString &value)=0;

    TQString attrName() const;
    TQDomElement const& domElement() const { return domEl; }

  protected:
     TQDomElement domEl;
     TQString name;
     QTag *m_dtdTag;
};


class Attr_line : public Attr
{
  protected:
    TQLineEdit *line;

  public:
    Attr_line( TQDomElement const& el, TQWidget *w, QTag *dtdTag ) : Attr(el, w, dtdTag)
        {  line = (TQLineEdit *)w; }
    virtual ~Attr_line(){};

    virtual TQString value() { return line->text(); }
    virtual void setValue(const TQString &value) { line->setText(value); }
};


class Attr_color : public Attr
{
  protected:
    ColorCombo *color;

  public:
    Attr_color( TQDomElement const& el, TQWidget *w, QTag *dtdTag ) : Attr(el, w, dtdTag)
        { color = (ColorCombo *)w; }
    virtual ~Attr_color(){};

    virtual TQString value() {  return color->colorName(); }
    virtual void setValue(const TQString &value) { color->setColorName(value); }
};

class Attr_file : public Attr
{
  protected:
    FileCombo *file;

  public:
    Attr_file( TQDomElement const& el, TQWidget *w , QTag * dtdTag ) : Attr(el, w, dtdTag)
        { file = (FileCombo *)w; }
    virtual ~Attr_file(){};

    virtual TQString value() {  return file->text(); }
    virtual void setValue(const TQString &value) { file->setText(value); }
};

class Attr_list : public Attr
{
  protected:
    TQComboBox *combo;

  public:
    Attr_list( TQDomElement const& el, TQWidget *w, QTag *dtdTag );
    virtual ~Attr_list(){};

    virtual TQString value() { return combo->currentText(); }
    virtual void setValue(const TQString &value);
};


class Attr_check : public Attr
{
  protected:
    TQCheckBox *check;

  public:
    Attr_check( TQDomElement const& el, TQWidget *w, QTag *dtdTag ) : Attr(el, w, dtdTag)
        { check = (TQCheckBox *)w; }
    virtual ~Attr_check(){};

    virtual TQString value() { return check->isChecked() ? "checked" : "unchecked" ; }
    virtual void setValue(const TQString &value) { check->setChecked( !value.isEmpty() ); }
};



#endif
