/***************************************************************************
                          cssselector.h  -  description
                             -------------------
    begin                : mer ago 6 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CSSSELECTOR_H
#define CSSSELECTOR_H

#include <tqmap.h>
#include <tqpair.h>
#include "cssselectors.h"

class TQListViewItem;
class TQStringList;
/**
  *@author gulmini luciano
  */

class CSSSelector : public CSSSelectorS {
  Q_OBJECT

  private:
    TQListViewItem *m_currentItem;
    TQListView *m_currentListView;
    TQString m_header,
                 m_footer,
                 m_callingFrom,
                 m_fileToPreview;
    TQMap<TQString, QPair<TQString,unsigned int> > m_currentStylesheetStructure;
    unsigned int m_orderNumber;
    bool m_stopProcessingStylesheet;

    void Connect();

  public:
    CSSSelector(TQWidget *parent=0, const char* name=0);
    ~CSSSelector();
    void loadCSSContent(const TQString& s);
    void setHeader(const TQString& h) { m_header = h; }
    void setFooter(const TQString& f) { m_footer = f; }
    void enableApplyToFile();
    void setCallingFrom(const TQString& cf){ m_callingFrom = cf ;}
    void setFileToPreview(const TQString& s){ m_fileToPreview=s;}
    bool errorOnProcessingStylesheet() const { return m_stopProcessingStylesheet; }
    TQString generateFormattedStyleSection();

  private slots:
    void openCSSEditor(TQListViewItem *);
    void addTag();
    void addClass();
    void addID();
    void addPseudo();
    void removeAll();
    void removeSelected();
    void setCurrentItem(TQListViewItem* i) { m_currentItem = i; }
    void setCurrentListView(TQWidget*);
    void setDTDTags(const TQString&);
    void setStylesheetProcessing(const TQString&);
};

#endif

