/***************************************************************************
                          wizard.h - Widget providing a wizard 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_WIZARD_H_
#define _HAVE_WIZARD_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqwizard.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
#include <myprocess.h>

class TQShowEvent;
class KOMMANDER_EXPORT Wizard : public TQWizard, public KommanderWidget
{
  Q_OBJECT

  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  Q_PROPERTY(HelpAction helpAction READ helpAction WRITE setHelpAction)
  Q_ENUMS(HelpAction)
  Q_PROPERTY(TQString helpActionText READ helpActionText WRITE setHelpActionText)

public:
  Wizard(TQWidget *, const char *, bool = true, int = 0);
  ~Wizard();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  virtual TQString handleDCOP(int function, const TQStringList& args);
  enum HelpAction { None, Command, Dialog };
  HelpAction helpAction() const;
  void setHelpAction(HelpAction);
  TQString helpActionText() const;
  void setHelpActionText(const TQString&);

public slots:
  virtual void setWidgetText(const TQString &);
  virtual void exec();
  virtual void show();
  virtual void runHelp();
  virtual void populate();
protected slots:
    virtual void initialize();
    virtual void destroy();

signals:
  void widgetOpened();
  void widgetTextChanged(const TQString &);
  void finished();
  void contextMenuRequested(int xpos, int ypos);
protected:
  void showEvent( TQShowEvent *e );
  void contextMenuEvent( TQContextMenuEvent * e );

  HelpAction m_helpAction;
  TQString m_helpActionText;
};

#endif
