/***************************************************************************
                  treewidget.h - Tree/detailed list widget
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HAVE_TREEWIDGET_H_
#define _HAVE_TREEWIDGET_H_

/* KDE INCLUDES */
#include <klistview.h>

/* QT INCLUDES */
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrvector.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>

class TQWidget;

class TQShowEvent;
class KOMMANDER_EXPORT TreeWidget : public KListView, public KommanderWidget
{
  Q_OBJECT
  
  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)
  Q_PROPERTY(TQString pathSeparator READ pathSeparator WRITE setPathSeparator)
  
public:
  TreeWidget(TQWidget *a_parent, const char *a_name);
  ~TreeWidget();
  virtual void setCurrentItem(TQListViewItem* item);  
  TQString pathSeparator() const;
  void setPathSeparator(const TQString& a_pathSep);

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWidgetText(const TQString&);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void contextMenuRequested(int xpos, int ypos);
protected:
  void showEvent(TQShowEvent *e);
  void contextMenuEvent( TQContextMenuEvent * e );
  int itemToIndex(TQListViewItem* item);
  int itemToIndexSafe(TQListViewItem* item);
  TQString itemText(TQListViewItem* item) const;
  TQString itemsText();
  TQListViewItem* indexToItem(int index);
  TQString itemPath(TQListViewItem* item) const;
private:
  void addItemFromString(const TQString& s);
  TQListViewItem* itemFromString(TQListViewItem* parent, const TQString& s);
  TQPtrVector<TQListViewItem> m_lastPath;
  TQString m_pathSeparator;
  int addColumnTree(const TQString & label, int width = -1 );
  void setSortCol(int column, bool ascending=true);
  void setAltBackground(const TQColor & c);
  void setColAlign(int column, const TQString& align);
};

#endif
