//
// C++ Implementation: toolbox
//
// Description: 
//
//
// Author: Andras Mantia <amantia@kdewebdev.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "toolbox.h"
#include "kommanderplugin.h"
#include "specials.h"


#include <klocale.h>

#define ADDWIDGET 120
#define CURRENTWIDGET 121
#define REMOVEWIDGET 122
#define REMOVEWIDGETAT 123
#define SETCURRENTWIDGET 124
#define CURRENTINDEX 125
#define WIDGETAT 126
#define INDEXOF 127
#define FIRST_FUNCTION ADDWIDGET
#define LAST_FUNCTION INDEXOF 

ToolBox::ToolBox(TQWidget *parent, const char *name)
 : TQToolBox(parent, name), KommanderWidget(this)
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
  KommanderPlugin::setDefaultGroup(Group::DCOP);
  KommanderPlugin::registerFunction(ADDWIDGET, "addWidget(TQString widget, TQString widgetName, TQString Label)",
         i18n("Adds a widget to the toolbox. Returns the index of the widget."), 3);
  KommanderPlugin::registerFunction(CURRENTWIDGET, "currentWidget(TQString widget)",
         i18n("Returns the name of the active widget."), 1);
  KommanderPlugin::registerFunction(REMOVEWIDGET, "removeWidget(TQString widget, TQString widgetName)", i18n("Remove the selected widget, returns the index of the removed widget or -1 if no such widget was found."), 2);
  KommanderPlugin::registerFunction(REMOVEWIDGETAT, "removeWidgetAt(TQString widget, int index)", i18n("Remove the widget from the index position, returns the index of the removed widget or -1 if no widget was found."), 2);
  KommanderPlugin::registerFunction(SETCURRENTWIDGET, "setCurrentWidget(TQString widget, TQString widgetName)",
         i18n("Activates the selected widget."), 2);
  KommanderPlugin::registerFunction(CURRENTINDEX, "currentIndex(TQString widget)",
         i18n("Returns the index of the active widget."), 1);
  KommanderPlugin::registerFunction(WIDGETAT, "widgetAt(TQString widget, int index)",
         i18n("Returns the widget having the supplied index."), 2);
  KommanderPlugin::registerFunction(INDEXOF, "indexOf(TQString widget, TQString widgetName)",
         i18n("Returns the index of the widget, -1 if the widget is not part of the toolbox."), 2);

}


ToolBox::~ToolBox()
{
}

TQString ToolBox::currentState() const
{
  return TQString("default");
}

bool ToolBox::isKommanderWidget() const
{
  return true;
}

void ToolBox::populate()
{
  setAssociatedText(KommanderWidget::evalAssociatedText( populationText()));
}

TQStringList ToolBox::associatedText() const
{
  return KommanderWidget::associatedText();
}

void ToolBox::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void ToolBox::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString ToolBox::populationText() const
{
  return KommanderWidget::populationText();
}


TQString ToolBox::addWidget(const TQString& widgetName, const TQString &label)
{
  KommanderWidget *w = widgetByName(widgetName);
  if (w)
  {
    int idx = addItem(dynamic_cast<TQWidget*>(w), label);
    adjustSize();
    return TQString::number(idx);
  } else
    return TQString("-1");

}

void ToolBox::showEvent(TQShowEvent* e)
{
  TQToolBox::showEvent(e);
  emit widgetOpened();
}

void ToolBox::contextMenuEvent( TQContextMenuEvent * e )
{
  e->accept();
  TQPoint p = e->globalPos();
  emit contextMenuRequested(p.x(), p.y());
}

bool ToolBox::isFunctionSupported(int f)
{
  return f == DCOP::count || f == DCOP::geometry || (f >= FIRST_FUNCTION && f <=  LAST_FUNCTION) ;
}

TQString ToolBox::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case ADDWIDGET:
      return addWidget(args[0], args[1]);   
      break;
    case CURRENTWIDGET:
    {
      TQWidget *w = currentItem();
      if (w) 
        return w->name();
      else
        return TQString();
      break;
    }
    case SETCURRENTWIDGET:
    {
      KommanderWidget *w = widgetByName(args[0]);
      setCurrentItem(dynamic_cast<TQWidget*>(w));
      return TQString();
    }
    case REMOVEWIDGET:
    {
      KommanderWidget *w = widgetByName(args[0]);
      return TQString::number(removeItem(dynamic_cast<TQWidget*>(w)));
    }
    case REMOVEWIDGETAT:
    {
      TQWidget *w = item(args[0].toInt());
      return TQString::number(removeItem(w));
    }
    case CURRENTINDEX:
    {
      return TQString::number(currentIndex());
      break;
    }
    case WIDGETAT:
    {
      TQWidget *w = item(args[0].toInt());
      if (w) 
        return w->name();
      else
        return TQString();
      break;
    }
    case INDEXOF:
    {
      KommanderWidget *w = widgetByName(args[0]);
      return TQString::number(indexOf(dynamic_cast<TQWidget*>(w)));
    }
    case DCOP::count:
      return TQString::number(count());
    case DCOP::geometry:
    {
      TQString geo = TQString::number(this->x())+" "+TQString::number(this->y())+" "+TQString::number(this->width())+" "+TQString::number(this->height());
      return geo;
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}
#include "toolbox.moc"
