/***************************************************************************
                          table.h - Table widget
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _HAVE_TABLE_H_
#define _HAVE_TABLE_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqtable.h>
#include <tqobject.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>

class TQWidget;

class KOMMANDER_EXPORT Table : public TQTable, public KommanderWidget
{
  Q_OBJECT

      Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
      Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
      Q_OVERRIDE(bool readOnly DESIGNABLE false)
      Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)

  public:
    Table(TQWidget *a_parent, const char *a_name);
    ~Table();

    virtual bool isKommanderWidget() const;
    virtual void setAssociatedText(const TQStringList&);
    virtual TQStringList associatedText() const;
    virtual TQString currentState() const;

    virtual TQString populationText() const;
    virtual void setPopulationText(const TQString&);

    virtual TQString handleDCOP(int function, const TQStringList& args);
    virtual bool isFunctionSupported(int function);
    virtual void clearCellWidget(int row, int col);
    virtual void columnClicked(int col);
  public slots:
    virtual void populate();
    virtual void setWidgetText(const TQString &);
    //void adjustColumn(int col);
  signals:
    void contextMenuRequested(int xpos, int ypos);
    void columnHeaderClicked(int col);
  protected:
    void contextMenuEvent( TQContextMenuEvent * e );
  private:
    TQString selectedArea();
    TQString cellWidget(int row, int col);
    void setCellWidget(int row, int col, const TQString &widgetName);
    void setCellText(int row, int col, const TQString &text);
};

#endif

