/***************************************************************************
                          subdialog.cpp - Subdialog widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqstringlist.h>
#include <tqevent.h>
#include <tqpushbutton.h>
#include <tqdialog.h>

/* OTHER INCLUDES */
#include <kdebug.h>
#include <kommanderfactory.h>
#include <kommanderwidget.h>
#include <specials.h>
#include "subdialog.h"

SubDialog::SubDialog(TQWidget *a_parent, const char *a_name)
  : TQPushButton(a_parent, a_name), KommanderWidget(this), m_dialog(0)
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);

  connect(this, TQT_SIGNAL(clicked()), this, TQT_SLOT(showDialog()));
  
}

SubDialog::~SubDialog()
{
}

TQString SubDialog::currentState() const
{
  return TQString("default");
}

bool SubDialog::isKommanderWidget() const
{
  return true;
}

TQStringList SubDialog::associatedText() const
{
  return KommanderWidget::associatedText();
}

void SubDialog::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void SubDialog::setPopulationText(const TQString& a_text)
{
    KommanderWidget::setPopulationText( a_text );
}

TQString SubDialog::populationText() const
{
    return KommanderWidget::populationText();
}

void SubDialog::populate()
{
    TQString txt = KommanderWidget::evalAssociatedText( populationText() );
//FIXME    
}


void SubDialog::setKmdrFile(TQString a_kmdrFile)
{
  m_kmdrFile = a_kmdrFile;
}

TQString SubDialog::kmdrFile() const
{
  return m_kmdrFile;
}

void SubDialog::showDialog()
{
  delete m_dialog;

  KommanderFactory::loadPlugins();
  m_dialog = (TQDialog *)KommanderFactory::create(kmdrFile());
  if(!m_dialog)
  {
    kdWarning() << "Creation of sub dialog failed .." << endl;
    connect(m_dialog, TQT_SIGNAL(finished()), this, TQT_SLOT(slotFinished()));

    m_dialog->exec();
  }
}

void SubDialog::slotFinished()
{
  if(m_dialog)
  {
    KommanderWidget *atw = dynamic_cast<KommanderWidget *>(m_dialog);
    if(atw)
      emit widgetTextChanged(atw->evalAssociatedText());
  }
}

void SubDialog::showEvent( TQShowEvent *e )
{
    TQPushButton::showEvent( e );
    emit widgetOpened();
}

TQString SubDialog::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
    {
      if (!m_dialog)
        return TQString();
      KommanderWidget *atw = dynamic_cast<KommanderWidget *>(m_dialog);
      if(atw)
        return atw->evalAssociatedText();
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "subdialog.moc"
