/***************************************************************************
                          spinboxint.h - Integer spinbox widget 
                             -------------------
    copyright            : (C) 2002 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _HAVE_SPINBOXINT_H_
#define _HAVE_SPINBOXINT_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqstring.h>
#include <tqspinbox.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
class TQWidget;

class TQShowEvent;
class KOMMANDER_EXPORT SpinBoxInt : public TQSpinBox, public KommanderWidget
{
  Q_OBJECT

  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  SpinBoxInt(TQWidget *a_parent, const char *a_name);
  ~SpinBoxInt();
  
  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWidgetText(const TQString&);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString&);
  void lostFocus();
  void gotFocus();
protected:
  void showEvent(TQShowEvent *e);
  void focusOutEvent( TQFocusEvent* e);
  void focusInEvent( TQFocusEvent* e);
private:
};

#endif
