/***************************************************************************
                          slider.cpp - Slider widget
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqevent.h>

/* OTHER INCLUDES */
#include <specials.h>
#include "slider.h"

Slider::Slider(TQWidget * a_parent, const char *a_name)
  : TQSlider(a_parent, a_name), KommanderWidget((TQObject *) this)
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

TQString Slider::currentState() const
{
  return TQString("default");
}

Slider::~Slider()
{
}

bool Slider::isKommanderWidget() const
{
  return true;
}

TQStringList Slider::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Slider::setAssociatedText(const TQStringList & a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Slider::setPopulationText(const TQString & a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString Slider::populationText() const
{
  return KommanderWidget::populationText();
}

void Slider::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
  setWidgetText(txt);
}

void Slider::setWidgetText(const TQString & a_text)
{
  setValue(a_text.toInt());
}

void Slider::showEvent(TQShowEvent * e)
{
  TQSlider::showEvent(e);
  emit widgetOpened();
}

bool Slider::isFunctionSupported(int f)
{
  return f == DCOP::text || f == DCOP::setText || f == DCOP::clear || f == DCOP::setMaximum || f == DCOP::getBackgroundColor || f == DCOP::setBackgroundColor;
}

TQString Slider::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::text:
      return TQString::number(value());
    case DCOP::setText:
      setValue(args[0].toInt());
      break;
    case DCOP::clear:
      setValue(minValue());
      break;
    case DCOP::setMaximum:
      setMaxValue(args[0].toInt());
      break;
    case DCOP::getBackgroundColor:
      return this->paletteBackgroundColor().name();
      break;
    case DCOP::setBackgroundColor:
    {
      TQColor color;
      color.setNamedColor(args[0]);
      this->setPaletteBackgroundColor(color);
      break;
    }
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "slider.moc"
