/***************************************************************************
                          scriptobject.h - Widget for holding scripts 
                             -------------------
    copyright            : (C) 2002      Marc Britton <consume@optusnet.com.au>
                           (C) 2003-2004 Michal Rudolf <mrudolf@kdewebdev.org>
    
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/
#ifndef _HAVE_SCRIPTOBJECT_H_
#define _HAVE_SCRIPTOBJECT_H_

/* KDE INCLUDES */

/* QT INCLUDES */
#include <tqlabel.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>

class KOMMANDER_EXPORT ScriptObject : public TQLabel, public KommanderWidget
{
  Q_OBJECT

  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)
      
public:
  ScriptObject(TQWidget *a_parent, const char *a_name);
  ~ScriptObject();

  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWidgetText(const TQString &);
  virtual void populate();
  virtual void execute();
  virtual void execute(const TQString&);
  virtual void execute(const TQString&, const TQString&);
  virtual void execute(int);
  virtual void execute(int, int);
  virtual void execute(bool);
signals:
  void widgetOpened();

protected:
  virtual TQString executeProcess(bool blocking);
private:
  TQStringList m_params;
};

#endif
