/***************************************************************************
                          lineedit.h - Lineedit widget 
                             -------------------
    copyright            : (C) 2002-2003 Marc Britton <consume@optusnet.com.au>
                           (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HAVE_LINEEDIT_H_
#define _HAVE_LINEEDIT_H_

/* KDE INCLUDES */
#include <klineedit.h>

/* QT INCLUDES */
#include <tqtextedit.h>
#include <tqstringlist.h>
#include <tqstring.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>

#include <kommander_export.h>
class TQShowEvent;

class KOMMANDER_EXPORT LineEdit : public KLineEdit, public KommanderWidget
{
  Q_OBJECT
  
  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)
public:
  LineEdit(TQWidget *, const char *);
  virtual ~LineEdit();
  
  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList&);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString&);

  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);
public slots:
  virtual void setWidgetText(const TQString &);
  virtual void setSelectedWidgetText(const TQString &a_text);
  virtual void populate();
signals:
  void widgetOpened();
  void widgetTextChanged(const TQString &);
  void contextMenuRequested(int xpos, int ypos);
  void gotFocus();
  void lostFocus();
protected:
  virtual void showEvent( TQShowEvent *e );
  void contextMenuEvent( TQContextMenuEvent * e );
  void focusInEvent( TQFocusEvent* e);
  void focusOutEvent( TQFocusEvent* e);
private:
};

#endif
