/***************************************************************************
                          konsole.h - Widget that shows output of a process
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _HAVE_KONSOLE_H_
#define _HAVE_KONSOLE_H_

/* KDE INCLUDES */
#include <ktextedit.h>

/* QT INCLUDES */
#include <tqobject.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>

class TQWidget;
class MyProcess;

class KOMMANDER_EXPORT Konsole : public KTextEdit, public KommanderWidget
{
  Q_OBJECT

  Q_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  Q_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  Q_OVERRIDE(bool readOnly DESIGNABLE false)
  Q_PROPERTY(bool KommanderWidget READ isKommanderWidget)

  public:
    Konsole(TQWidget *a_parent, const char *a_name);
    ~Konsole();

    virtual bool isKommanderWidget() const;
    virtual void setAssociatedText(const TQStringList&);
    virtual TQStringList associatedText() const;
    virtual TQString currentState() const;

    virtual TQString populationText() const;
    virtual void setPopulationText(const TQString&);

    virtual TQString handleDCOP(int function, const TQStringList& args);
    virtual bool isFunctionSupported(int function);
  public slots:
    virtual void populate();
    virtual void setWidgetText(const TQString &);
    // Execute current script
    virtual void execute();
    // Stop executing current script
    virtual void cancel();
    // Process has ended
    virtual void processReceivedStdout(MyProcess*, char* a_buffer, int a_len);
    virtual void processExited(MyProcess* p);
  signals:
    void finished();
  protected:
    // Whether last line of output was ended with EOL
    bool mSeenEOL;
    // Current process or NULL if there is no process running
    MyProcess* mProcess;
};

#endif
