/***************************************************************************
                          konsole.cpp - Widget that shows output of a process
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT INCLUDES */
#include <tqcursor.h>
#include <tqstring.h>
#include <tqstringlist.h>
#include <tqwidget.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <specials.h>
#include "konsole.h"
#include <myprocess.h>

Konsole::Konsole(TQWidget* a_parent, const char* a_name)
  : KTextEdit(a_parent, a_name), KommanderWidget(this), mSeenEOL(false), mProcess(false)
{
  TQStringList states;
  states << "default";
  setStates(states);
  setDisplayStates(states);
}

Konsole::~Konsole()
{
}

TQString Konsole::currentState() const
{
  return TQString("default");
}

bool Konsole::isKommanderWidget() const
{
  return true;
}

TQStringList Konsole::associatedText() const
{
  return KommanderWidget::associatedText();
}

void Konsole::setAssociatedText(const TQStringList& a_at)
{
  KommanderWidget::setAssociatedText(a_at);
}

void Konsole::setPopulationText(const TQString& a_text)
{
  KommanderWidget::setPopulationText(a_text);
}

TQString Konsole::populationText() const
{
  return KommanderWidget::populationText();
}

void Konsole::populate()
{
  TQString txt = KommanderWidget::evalAssociatedText(populationText());
  setWidgetText(txt);
}

void Konsole::setWidgetText(const TQString&)
{
//  FIXME: emit widgetTextChanged(a_text);
}

void Konsole::execute()
{
  TQString at = evalAssociatedText().stripWhiteSpace();
  if (mProcess)
    cancel();
  mSeenEOL = false;
  mProcess = new MyProcess(this);
  mProcess->setBlocking(false);
  connect(mProcess, TQT_SIGNAL(processExited(MyProcess*)), TQT_SLOT(processExited(MyProcess*)));
  connect(mProcess, TQT_SIGNAL(processReceivedStdout(MyProcess*, char*, int)), TQT_SLOT(processReceivedStdout(MyProcess*, char*, int)));
  setCursor(TQCursor(Qt::WaitCursor));
  mProcess->run(at);
}

void Konsole::cancel()
{
  if (!mProcess) 
    return;
  mProcess->cancel();
  processExited(mProcess);
}


void Konsole::processReceivedStdout(MyProcess*, char* buffer, int buflen)
{
  TQString pBuf = TQString::fromLocal8Bit(buffer, buflen);  
  if (mSeenEOL)
    pBuf = '\n' + pBuf;
  mSeenEOL = pBuf[pBuf.length()-1] == '\n';
  if (mSeenEOL)
    pBuf = pBuf.left(pBuf.length()-1);
  insert(pBuf);
}

void Konsole::processExited(MyProcess*)
{
  unsetCursor();
  delete mProcess;
  mProcess = 0;
  emit finished();
}

bool Konsole::isFunctionSupported(int f)
{
  return f == DCOP::setText || f == DCOP::text || f == DCOP::clear || f == DCOP::execute || f == DCOP::cancel;
}

TQString Konsole::handleDCOP(int function, const TQStringList& args)
{
  switch (function) {
    case DCOP::setText:
      setWidgetText(args[0]);
      break;
    case DCOP::text:
      return text();
    case DCOP::clear:
      clear();
      break;
    case DCOP::execute:
      execute();
      break;
    case DCOP::cancel:
      cancel();
      break;
    default:
      return KommanderWidget::handleDCOP(function, args);
  }
  return TQString();
}


#include "konsole.moc"
