/****************************************************************************
  ** kommanderplugin.h - KommanderPlugin class definition created from QWidgetPlugin
  ** Copyright (C) 2001 Trolltech AS.  All rights reserved.
  ** Copyright (C) 2003 Marc Britton
  **
  ** This file is part of the widgets module of the Qt GUI Toolkit.
  **
  ** This file may be distributed under the terms of the Q Public License
  ** as defined by Trolltech AS of Norway and appearing in the file
  ** LICENSE.QPL included in the packaging of this file.
  **
  ** This file may be distributed and/or modified under the terms of the
  ** GNU General Public License version 2 as published by the Free Software
  ** Foundation and appearing in the file LICENSE.GPL included in the
  ** packaging of this file.
  **
  ** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
  ** licenses may use this file in accordance with the Qt Commercial License
  ** Agreement provided with the Software.
  **
  ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
  ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
  **
  ** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
  **   information about Qt Commercial License Agreements.
  ** See http://www.trolltech.com/qpl/ for QPL licensing information.
  ** See http://www.trolltech.com/gpl/ for GPL licensing information.
  **
  ** Contact info@trolltech.com if any conditions of this licensing are
  ** not clear to you.
  **
  **********************************************************************/

#ifndef _HAVE_KOMMANDERPLUGIN_H_
#define _HAVE_KOMMANDERPLUGIN_H_

#include <tqobject.h>
#include <tqmap.h>
#include <tqstringlist.h>
#include "kommander_export.h"

class TQWidget;
class TQIconSet;

class KOMMANDER_EXPORT KommanderPlugin : public TQObject 
{
    Q_OBJECT
    public:
    KommanderPlugin();
    ~KommanderPlugin();

    virtual void addWidget( const TQString &name, const TQString &group, const TQString &toolTip, TQIconSet *iconSet, const TQString &whatsThis = TQString::null, bool isContainer = false);
    virtual void removeWidget( const TQString &name );
    virtual TQStringList widgets() const;

    virtual TQWidget *create( const TQString &key, TQWidget *parent = 0, const char *name = 0 ) = 0;
    virtual TQString group( const TQString &key ) const;
    virtual TQString toolTip( const TQString &key ) const;
    virtual TQString whatsThis( const TQString &key ) const;
    virtual bool isContainer( const TQString &key ) const;
    virtual TQIconSet *iconSet( const TQString &key ) const;

    /**
     * Sets the default group for functions. Must be called before registerFunction.
     * @param group the groups ID
     */
    static void setDefaultGroup(int group);

    /**
     * Register a function of the plugin.
     * @param id Kommander wide unique ID
     * @param function function signature
     * @param description description of what the function does
     * @param minArgs minimum number of accepted arguments
     * @param maxArgs maximum number of accepted arguments
     * @return true if registration was successful
     */
    static bool registerFunction(int id, const TQString& function, const TQString description = TQString::null,
    int minArgs = -1, int maxArgs = -1);

    

private:
    struct WidgetInfo
    {
      WidgetInfo() { }
      WidgetInfo( const TQString &g, const TQString &t, TQIconSet *i, const TQString &w = TQString::null, bool c = false)
          : group( g ), toolTip( t ), iconSet(i), whatsThis( w ), isContainer( c )
      {}

      TQString group;
      TQString toolTip;
      TQIconSet *iconSet;
      TQString whatsThis;
      bool isContainer;
    };
    typedef TQMap<TQString, WidgetInfo> WidgetInfos;
    WidgetInfos m_widgets;
};

#define KOMMANDER_EXPORT_PLUGIN(plugin) extern "C" { KOMMANDER_EXPORT void *kommander_plugin() { return new plugin; } }

#endif // _HAVE_KOMMANDERPLUGIN_H_
