/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef RESOURCE_H
#define RESOURCE_H

#include <tqstring.h>
#include <tqtextstream.h>
#include <tqvariant.h>
#include <tqvaluelist.h>
#include <tqimage.h>
#include "actiondnd.h"

#include "metadatabase.h"

class TQWidget;
class TQObject;
class TQLayout;
class TQStyle;
class TQPalette;
class FormWindow;
class MainWindow;
class TQDomElement;
class QDesignerGridLayout;
class TQListViewItem;
class TQMainWindow;
#ifndef KOMMANDER
struct LanguageInterface;
#endif
class FormFile;

class Resource
{
public:
    struct Image {
	TQImage img;
	TQString name;
	bool operator==(  const Image &i ) const {
	    return ( i.name == name &&
		     i.img == img );
	}
    };

    Resource();
    Resource( MainWindow* mw );
    ~Resource();

    void setWidget( FormWindow *w );
    TQWidget *widget() const;

    bool load( FormFile *ff );
    bool load( FormFile *ff, TQIODevice* );
    TQString copy();

    bool save( const TQString& filename, bool formCodeOnly = FALSE);
    bool save( TQIODevice* );
    void paste( const TQString &cb, TQWidget *parent );

    static void saveImageData( const TQImage &img, TQTextStream &ts, int indent );
    static void loadCustomWidgets( const TQDomElement &e, Resource *r );

private:
    void saveObject( TQObject *obj, QDesignerGridLayout* grid, TQTextStream &ts, int indent );
    void saveChildrenOf( TQObject* obj, TQTextStream &ts, int indent );
    void saveObjectProperties( TQObject *w, TQTextStream &ts, int indent );
    void saveSetProperty( TQObject *w, const TQString &name, TQVariant::Type t, TQTextStream &ts, int indent );
    void saveEnumProperty( TQObject *w, const TQString &name, TQVariant::Type t, TQTextStream &ts, int indent );
    void saveProperty( TQObject *w, const TQString &name, const TQVariant &value, TQVariant::Type t, TQTextStream &ts, int indent );
    void saveProperty( const TQVariant &value, TQTextStream &ts, int indent );
    void saveItems( TQObject *obj, TQTextStream &ts, int indent );
    void saveItem( const TQStringList &text, const TQPtrList<TQPixmap> &pixmaps, TQTextStream &ts, int indent );
    void saveItem( TQListViewItem *i, TQTextStream &ts, int indent );
    void saveConnections( TQTextStream &ts, int indent );
    void saveCustomWidgets( TQTextStream &ts, int indent );
    void saveTabOrder( TQTextStream &ts, int indent );
    void saveColorGroup( TQTextStream &ts, int indent, const TQColorGroup &cg );
    void saveColor( TQTextStream &ts, int indent, const TQColor &c );
    void saveMetaInfoBefore( TQTextStream &ts, int indent );
    void saveMetaInfoAfter( TQTextStream &ts, int indent );
    void savePixmap( const TQPixmap &p, TQTextStream &ts, int indent, const TQString &tagname = "pixmap" );
    void saveActions( const TQPtrList<TQAction> &actions, TQTextStream &ts, int indent );
    void saveChildActions( TQAction *a, TQTextStream &ts, int indent );
    void saveToolBars( TQMainWindow *mw, TQTextStream &ts, int indent );
    void saveMenuBar( TQMainWindow *mw, TQTextStream &ts, int indent );
#ifndef KOMMANDER
//    void saveFormCode();
#endif

    TQObject *createObject( const TQDomElement &e, TQWidget *parent, TQLayout* layout = 0 );
    TQWidget *createSpacer( const TQDomElement &e, TQWidget *parent, TQLayout *layout, Qt::Orientation o );
    void createItem( const TQDomElement &e, TQWidget *widget, TQListViewItem *i = 0 );
    void createColumn( const TQDomElement &e, TQWidget *widget );
    void setObjectProperty( TQObject* widget, const TQString &prop, const TQDomElement &e);
    TQString saveInCollection( const TQImage &img );
    TQString saveInCollection( const TQPixmap &pix ) { return saveInCollection( pix.convertToImage() ); }
    TQImage loadFromCollection( const TQString &name );
    void saveImageCollection( TQTextStream &ts, int indent );
    void loadImageCollection( const TQDomElement &e );
    void loadConnections( const TQDomElement &e );
    void loadTabOrder( const TQDomElement &e );
    void loadItem( const TQDomElement &n, TQPixmap &pix, TQString &txt, bool &hasPixmap );
    void loadActions( const TQDomElement &n );
    void loadChildAction( TQObject *parent, const TQDomElement &e );
    void loadToolBars( const TQDomElement &n );
    void loadMenuBar( const TQDomElement &n );
    TQColorGroup loadColorGroup( const TQDomElement &e );
    TQPixmap loadPixmap( const TQDomElement &e, const TQString &tagname = "pixmap" );
#ifndef KOMMANDER
//    void loadFunctions( const TQDomElement &e ); // compatibility with early 3.0 betas
//    void loadExtraSource();
#endif

private:
    MainWindow *mainwindow;
    FormWindow *formwindow;
    TQWidget* toplevel;
    TQValueList<Image> images;
    bool copying, pasting;
    bool mainContainerSet;
    TQStringList knownNames;
    TQStringList usedCustomWidgets;
    TQListViewItem *lastItem;

    TQValueList<MetaDataBase::Include> metaIncludes;
    TQStringList metaForwards;
    TQStringList metaVariables;
    TQStringList metaSignals;
    MetaDataBase::MetaInfo metaInfo;
    TQMap<TQString, TQString> dbControls;
    TQMap<TQString, TQStringList> dbTables;
    TQString exportMacro;
    bool hadGeometry;
    TQMap<TQString, TQValueList<MetaDataBase::Connection> > langConnections;
    TQString currFileName;
#ifndef KOMMANDER
    LanguageInterface *langIface;
#endif
    bool hasFunctions;

};

#endif
