#ifndef QCOMPLETIONEDIT_H
#define QCOMPLETIONEDIT_H

#include <tqlineedit.h>
#include <tqstringlist.h>

class TQListBox;
class TQVBox;

class QCompletionEdit : public QLineEdit
{
    Q_OBJECT
    Q_PROPERTY( bool autoAdd READ autoAdd WRITE setAutoAdd )
    Q_PROPERTY( bool caseSensitive READ isCaseSensitive WRITE setCaseSensitive )

public:
    QCompletionEdit( TQWidget *parent = 0, const char *name = 0 );

    bool autoAdd() const;
    TQStringList completionList() const;
    bool eventFilter( TQObject *o, TQEvent *e );
    bool isCaseSensitive() const;

public slots:
    void setCompletionList( const TQStringList &l );
    void setAutoAdd( bool add );
    void clear();
    void addCompletionEntry( const TQString &entry );
    void removeCompletionEntry( const TQString &entry );
    void setCaseSensitive( bool b );

signals:
    void chosen( const TQString &text );

private slots:
    void textDidChange( const TQString &text );

private:
    void placeListBox();
    void updateListBox();

private:
    bool aAdd;
    TQStringList compList;
    TQListBox *listbox;
    TQVBox *popup;
    bool caseSensitive;

};



#endif
