/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef ORDER_INDICATOR_H
#define  ORDER_INDICATOR_H

#include <tqwidget.h>

class FormWindow;

class OrderIndicator : public QWidget
{
    Q_OBJECT

public:
    OrderIndicator( int i, TQWidget* w, FormWindow* fw );
    ~OrderIndicator();

    void setOrder( int i, TQWidget* w );
    void reposition();

protected:
    void paintEvent( TQPaintEvent * );
    void mousePressEvent( TQMouseEvent *e );
    void updateMask();

private:
    int order;
    TQWidget* widget;
    FormWindow *formWindow;
    
};


#endif
