/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of Qt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef MULTILINEEDITORIMPL_H
#define MULTILINEEDITORIMPL_H

#include "multilineeditor.h"

class FormWindow;
class TQMultiLineEdit;

class MultiLineEditor : public MultiLineEditorBase
{
    Q_OBJECT

public:
    MultiLineEditor( TQWidget *parent, TQWidget *editWidget, FormWindow *fw );

protected slots:
    void okClicked();
    void applyClicked();

private:
    TQMultiLineEdit *mlined;
    FormWindow *formwindow;

};

class TextEditor : public MultiLineEditorBase
{
    Q_OBJECT

public:
    TextEditor( TQWidget *parent, const TQString &text );

    static TQString getText( TQWidget *parent, const TQString &text );
    
protected slots:
    void okClicked();
    void applyClicked();

};

#endif
