#ifndef FILECHOOSER_H
#define FILECHOOSER_H

#include <tqwidget.h>

class TQLineEdit;
class TQPushButton;

class FileChooser : public QWidget
{
    Q_OBJECT

    Q_ENUMS( Mode )
    Q_PROPERTY( Mode mode READ mode WRITE setMode )
    Q_PROPERTY( TQString fileName READ fileName WRITE setFileName )

public:
    FileChooser( TQWidget *parent = 0, const char *name = 0);

    enum Mode { File, Directory };

    TQString fileName() const;
    Mode mode() const;

public slots:
    void setFileName( const TQString &fn );
    void setMode( Mode m );

signals:
    void fileNameChanged( const TQString & );

private slots:
    void chooseFile();

private:
    TQLineEdit *lineEdit;
    TQPushButton *button;
    Mode md;

};

#endif
