/***************************************************************************
 *   Copyright (C) 2004 by Paulo Moura Guedes                              *
 *   moura@kdewebdev.org                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef HTTP_H
#define HTTP_H

#include <tqhttp.h>
#include <tqstring.h>


class HttpResponseHeader: public QHttpResponseHeader
{
public:

  HttpResponseHeader();
  HttpResponseHeader(const TQHttpResponseHeader & header);
  HttpResponseHeader(TQString const& str);
  virtual ~HttpResponseHeader();

  void parseLocation();
  TQString const& location() const;
  TQString charset() const;
  
  /**
   * Parses the charset from this kind of server response: 
   * Content-Type: text/html; charset=EUC-JP
   * Return an empty string in case it doesn't find nothing.
   */
  static TQString charset(TQString const& contentTypeHttpHeaderLine);

private:

  TQString location_;
};


inline HttpResponseHeader::HttpResponseHeader()
  : TQHttpResponseHeader()
{
}

inline HttpResponseHeader::HttpResponseHeader(const TQHttpResponseHeader & /*header*/)
  : TQHttpResponseHeader()
{
}

inline HttpResponseHeader::HttpResponseHeader(TQString const& str)
  : TQHttpResponseHeader()
{
	parse(str);
}

inline HttpResponseHeader::~HttpResponseHeader()
{
}

inline TQString const& HttpResponseHeader::location() const
{
  return location_;
}

#endif
