/***************************************************************************
                          kimedialogs.h  -  description
                             -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMEDIALOGS_H
#define KIMEDIALOGS_H

#include <kdialog.h>
#include <kdialogbase.h>

#include <kurl.h>
#include "kimagemapeditor.h"

#include "kdeversion.h"

class TQLineEdit;
class TQMultiLineEdit;
class TQSpinBox;


class CoordsEdit : public TQWidget {
Q_OBJECT
	public :
		CoordsEdit(TQWidget *parent, Area* a);
		virtual ~CoordsEdit();
		virtual void applyChanges();
	protected:
		Area *area;   // The working area
	protected slots:
		void slotTriggerUpdate();
	signals:
		void update();
};

class RectCoordsEdit : public CoordsEdit {
	public:
		RectCoordsEdit(TQWidget *parent, Area* a);
		virtual void applyChanges();
	private:
		TQSpinBox *topXSpin;
		TQSpinBox *topYSpin;
		TQSpinBox *widthSpin;
		TQSpinBox *heightSpin;
};

class CircleCoordsEdit : public CoordsEdit {
	public:
		CircleCoordsEdit(TQWidget *parent, Area* a);
		virtual void applyChanges();
	private:
		TQSpinBox *centerXSpin;
		TQSpinBox *centerYSpin;
		TQSpinBox *radiusSpin;
};

class TQTable;

class PolyCoordsEdit : public CoordsEdit {
Q_OBJECT	
	public:
		PolyCoordsEdit(TQWidget *parent, Area* a);
		~PolyCoordsEdit();
		virtual void applyChanges();
	private:
		TQTable *coordsTable;
	protected slots:
  	void slotAddPoint();
  	void slotRemovePoint();
  	void slotHighlightPoint(int);

};

class SelectionCoordsEdit : public CoordsEdit {
Q_OBJECT	
	public:
		SelectionCoordsEdit(TQWidget *parent, Area* a);
		virtual void applyChanges();
	private:
		TQSpinBox *topXSpin;
		TQSpinBox *topYSpin;

};


class TQCheckBox;
class TQGridLayout;

class AreaDialog : public KDialog {
Q_OBJECT
	private:
		Area *area;
		Area *oldArea; // Only for drawing reasons
		Area *areaCopy; // A copy for restoring the original area if user press cancel
		TQLineEdit *hrefEdit;
		TQLineEdit *altEdit;
		TQLineEdit *targetEdit;
		TQLineEdit *titleEdit;
		
		TQLineEdit *onClickEdit;
		TQLineEdit *onDblClickEdit;
		TQLineEdit *onMouseDownEdit;
		TQLineEdit *onMouseUpEdit;
		TQLineEdit *onMouseOverEdit;
		TQLineEdit *onMouseMoveEdit;
		TQLineEdit *onMouseOutEdit;
		
		CoordsEdit *coordsEdit;
		CoordsEdit* createCoordsEdit(TQWidget *parent, Area *a);
		TQCheckBox *defaultAreaChk;
		KImageMapEditor *_document;
		

	public:
		AreaDialog(KImageMapEditor* parent,Area * a);
		~AreaDialog();
	protected slots:
		virtual void slotOk();
		virtual void slotApply();
		virtual void slotCancel();
		void slotChooseHref();
		void slotUpdateArea();
		
    TQLineEdit* createLineEdit(TQWidget* parent, TQGridLayout *layout, int y, const TQString & value, const TQString & name);
	  TQWidget* createGeneralPage();
	  TQWidget* createCoordsPage();
	  TQWidget* createJavascriptPage();
	  TQWidget* createButtonBar();
	signals:
		void areaChanged(Area* a);
};

class TQLineEdit;
class TQListBox;
class TQLabel;


class ImageMapChooseDialog : public KDialogBase {
Q_OBJECT
	private:
		TQTable *imageListTable;
		TQLabel *imagePreview;		
		TQListBox *mapListBox;	
		TQLineEdit *mapNameEdit;
		TQPtrList<MapTag> *maps;
		TQPtrList<ImageTag> *images;
		KURL baseUrl;
    void initImageListTable(TQWidget*);    
	public:
		ImageMapChooseDialog(TQWidget* parent,TQPtrList<MapTag> *_maps,TQPtrList<ImageTag> *_images, const KURL & _baseUrl);
		~ImageMapChooseDialog();
		KURL pixUrl;
		MapTag* currentMap;
	protected slots:
		void slotImageChanged();
		void slotMapChanged(int i);
        void selectImageWithUsemap(const TQString & usemap);
      
};

class KConfig;

class PreferencesDialog : public KDialogBase {
Q_OBJECT
	public:
		PreferencesDialog(TQWidget *parent,KConfig*);
		~PreferencesDialog();
	protected slots:
	  virtual void slotDefault( void );
  	virtual void slotOk( void );
  	virtual void slotApply( void );
	private:
		TQSpinBox *rowHeightSpinBox;
		TQSpinBox *undoSpinBox;
		TQSpinBox *redoSpinBox;
//		TQCheckBox *colorizeAreaChk;
//		TQCheckBox *showAltChk;
    TQCheckBox *startWithCheck;
    KConfig *config;
};

class KHTMLPart;
class KTempFile;

class HTMLPreviewDialog : public KDialogBase {
  public:
    HTMLPreviewDialog(TQWidget *, KURL, const TQString &);
    ~HTMLPreviewDialog();
    virtual void show();
  private:
    KHTMLPart* htmlPart;
    KTempFile* tempFile;
};

#endif
