/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2002-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/


#ifndef UMLOPERATIONDIALOG_H
#define UMLOPERATIONDIALOG_H

//kde includes
#include <kdialogbase.h>

/**
 * @author Paul Hensgen
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.kde.org
 */

class UMLOperation;
class ListPopupMenu;
class TQGroupBox;
class TQListBox;
class TQButtonGroup;
class TQRadioButton;
class TQPushButton;
class TQLabel;
class TQCheckBox;
class KComboBox;
class TQLineEdit;
class UMLDoc;
class KArrowButton;

class UMLOperationDialog : public KDialogBase {
    Q_OBJECT

public:
    /**
    *   Constructor
    */
    UMLOperationDialog( TQWidget * parent, UMLOperation * pOperation );

    /**
    *   Deconstructor
    */
    ~UMLOperationDialog();

protected:
    /**
    *   Sets up the dialog
    */
    void setupDialog();

    /**
     * Checks if changes are valid and applies them if they are,
     * else returns false
     */
    bool apply();

    /**
    * Inserts @p type into the type-combobox as well as its completion object.
    */
    void insertType( const TQString& type, int index = -1 );

    /**
    *   The operation to represent.
    */
    UMLOperation * m_pOperation;

    /**
      * The UMLDocument where all objects live
     */
    UMLDoc *m_doc;

    /**
    *   Menu used in paramater list box.
    */
    ListPopupMenu * m_pMenu;

    /**
    * Inserts @p stereotype into the stereotype-combobox as well as its completion object.
    */
    void insertStereotype( const TQString& type, int index = -1 );

    //GUI widgets
    TQGroupBox  * m_pParmsGB, * m_pGenGB;
    TQListBox * m_pParmsLB;
    TQButtonGroup * m_pScopeBG;
    TQRadioButton * m_pPublicRB, * m_pPrivateRB,  * m_pProtectedRB, *m_pImplementationRB;
    TQLabel * m_pRtypeL, * m_pNameL, * m_pStereoTypeL;
    KComboBox * m_pRtypeCB, * m_pStereoTypeCB;
    TQLineEdit * m_pNameLE;
    TQCheckBox * m_pAbstractCB;
    TQCheckBox * m_pStaticCB;
    TQCheckBox * m_pQueryCB;
    TQPushButton* m_pDeleteButton;
    TQPushButton* m_pPropertiesButton;
    KArrowButton* m_pUpButton;
    KArrowButton* m_pDownButton;

public slots:
    void slotParmRightButtonPressed(TQListBoxItem *item, const TQPoint &p);
    void slotParmRightButtonClicked(TQListBoxItem *item, const TQPoint &p);
    void slotParmDoubleClick(TQListBoxItem *item);
    void slotParmPopupMenuSel(int id);
    void slotNewParameter();
    void slotDeleteParameter();
    void slotParameterProperties();
    void slotParameterUp();
    void slotParameterDown();

    /**
     * enables or disables buttons
     */
    void slotParamsBoxClicked(TQListBoxItem* parameterItem);

    /**
     * I don't think this is used, but if we had an apply button
     * it would slot into here
     */
    void slotApply();

    /**
     * Used when the OK button is clicked.  Calls apply()
     */
    void slotOk();
    void slotNameChanged( const TQString & );

};

#endif
