/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *  copyright (C) 2002-2006                                                *
 *  Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                   *
 ***************************************************************************/


#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H
//qt includes
#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqdict.h>
//kde includes
#include <kcombobox.h>
#include <kfontdialog.h>
#include <kdialogbase.h>
#include <kcolorbutton.h>
#include <knuminput.h>
//app includes

#include "../optionstate.h"

class CodeGenerationOptionsPage;
class CodeViewerOptionsPage;
class CodeGenerator;

/**
 * @author Paul Hensgen
 * modified by brian thomas Aug-2003
 * Bugs and comments to uml-devel@lists.sf.net or http://bugs.kde.org
 */

class SettingsDlg : public KDialogBase {

    Q_OBJECT

public:
    SettingsDlg(TQWidget * parent, Settings::OptionState *state);
    ~SettingsDlg();

    //public methods
    bool getChangesApplied() {
        return m_bChangesApplied;
    }

    TQString getCodeGenerationLanguage();

protected:
    /**
    * Inserts @p type into the type-combobox as well as its completion object.
    */
    void insertDiagram( const TQString& type, int index = -1 );
    /**
    * Inserts @p type into the type-combobox as well as its completion object.
    */
    void insertAttribScope( const TQString& type, int index = -1 );
    /**
    * Inserts @p type into the type-combobox as well as its completion object.
    */
    void insertOperationScope( const TQString& type, int index = -1 );

private:
    //private structs
    struct UIWidgets {
        TQGroupBox * colorGB;

        TQLabel * lineColorL;
        TQLabel * fillColorL;
        TQLabel * lineWidthL;

        TQPushButton * lineDefaultB;
        TQPushButton * fillDefaultB;
        TQPushButton * lineWidthDefaultB;

        KColorButton * lineColorB;
        KColorButton * fillColorB;
        KIntSpinBox  * lineWidthB;

        TQCheckBox * useFillColorCB;
    }
    ;//end struct UIWidgets

    struct GeneralWidgets {
        TQGroupBox * miscGB;
        TQGroupBox * autosaveGB;
        TQGroupBox * startupGB;

        KIntSpinBox * timeISB;
        KComboBox * diagramKB;

        TQCheckBox * undoCB;
        TQCheckBox * tabdiagramsCB;
        TQCheckBox * newcodegenCB;
        TQCheckBox * angularLinesCB;
        TQCheckBox * autosaveCB;
        TQCheckBox * logoCB;
        TQCheckBox * tipCB;
        TQCheckBox * loadlastCB;

        // 2004-05-17 Achim Spangler: Allow definition of Suffix for autosave
        // ( Default: ".xmi" )
        TQLineEdit * autosaveSuffixT;
        TQLabel    * autosaveSuffixL;
        // End AutoSave Suffix

        TQLabel * startL;
        TQLabel *  autosaveL;
    }
    ;//end struct GeneralWidgets

    struct ClassWidgets {
        TQGroupBox * visibilityGB;
        TQGroupBox * scopeGB;

        TQCheckBox * showVisibilityCB;
        TQCheckBox * showAttsCB;
        TQCheckBox * showOpsCB;
        TQCheckBox * showStereotypeCB;
        TQCheckBox * showAttSigCB;
        TQCheckBox * showPackageCB;

        TQCheckBox * showOpSigCB;

        TQLabel * attributeLabel;
        TQLabel * operationLabel;

        KComboBox* m_pAttribScopeCB;
        KComboBox* m_pOperationScopeCB;

    }
    ;//end struct ClassWidgets

    struct FontWidgets {
        KFontChooser * chooser;
    };

    //private methods
    void setupFontPage();
    void setupUIPage();
    void setupGeneralPage();
    void setupClassPage();
    void setupCodeGenPage();
    void setupCodeViewerPage(Settings::CodeViewerState options);
    void applyPage( Settings::Page page );

    //private attributes
    FontWidgets m_FontWidgets;
    GeneralWidgets m_GeneralWidgets;
    UIWidgets m_UiWidgets;
    ClassWidgets m_ClassWidgets;
    Settings::OptionState *m_pOptionState;
    CodeGenerationOptionsPage * m_pCodeGenPage;
    CodeViewerOptionsPage * m_pCodeViewerPage;

    KConfig * m_pCfg;
    bool m_bChangesApplied;

private slots:
    void slotApply();
    void slotOk();
    void slotDefault();
    void slotLineBClicked();
    void slotFillBClicked();
    void slotAutosaveCBClicked();
};

#endif
