/***************************************************************************
                          rubycodedocumentation.cpp
                          Derived from the Java code generator by thomas

    begin                : Thur Jul 21 2005
    author               : Richard Dale
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2006-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "rubycodedocumentation.h"

// qt/kde includes
#include <tqregexp.h>
#include <kdebug.h>

// local includes
#include "rubyclassifiercodedocument.h"
#include "rubycodegenerationpolicy.h"
#include "../uml.h"

// Constructors/Destructors
//

RubyCodeDocumentation::RubyCodeDocumentation ( RubyClassifierCodeDocument * doc, const TQString & text )
        : CodeComment ((CodeDocument*) doc, text)
{

}

RubyCodeDocumentation::~RubyCodeDocumentation ( ) { }

//
// Methods
//


// Accessor methods
//

// Other methods
//

/**
 * Save the XMI representation of this object
 */
void RubyCodeDocumentation::saveToXMI ( TQDomDocument & doc, TQDomElement & root ) {
    TQDomElement blockElement = doc.createElement( "rubycodedocumentation" );
    setAttributesOnNode(doc, blockElement); // as we added no additional fields to this class we may
    // just use parent TextBlock method
    root.appendChild( blockElement );
}

/**
 * @return    QString
 */
TQString RubyCodeDocumentation::toString ( )
{

    TQString output = "";

    // simple output method
    if(getWriteOutText())
    {
        bool  useHashOutput = true;

        // need to figure out output type from ruby policy
        CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
        if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
             useHashOutput = false;

        TQString indent = getIndentationString();
        TQString endLine = getNewLineEndingChars();
        TQString body = getText();
        if( useHashOutput)
        {
            if(!body.isEmpty())
                output.append(formatMultiLineText (body, indent +"# ", endLine));
        } else {
            output.append("=begin rdoc"+endLine);
            output.append(formatMultiLineText (body, indent +' ', endLine));
            output.append("=end"+endLine);
        }
    }

    return output;
}

TQString RubyCodeDocumentation::getNewEditorLine ( int amount )
{
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
        return getIndentationString(amount) + ' ';
    else
        return getIndentationString(amount) + "# ";
}

int RubyCodeDocumentation::firstEditableLine() {
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
        return 1;
    return 0;
}

int RubyCodeDocumentation::lastEditableLine() {
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
    {
        return -1; // very last line is NOT editable
    }
    return 0;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
TQString RubyCodeDocumentation::unformatText ( const TQString & text , const TQString & indent)
{

    TQString mytext = TextBlock::unformatText(text, indent);
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    // remove leading or trailing comment stuff
    mytext.remove(TQRegExp('^'+indent));
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
    {
        mytext.remove(TQRegExp("^=begin\\s*(rdoc)?\\s*\n?"));
        mytext.remove(TQRegExp("^=end\\s*\n?$"));
    } else
        mytext.remove(TQRegExp("^#\\s*"));

    return mytext;
}


#include "rubycodedocumentation.moc"
