/***************************************************************************
                          rubycodecomment.cpp
                          Derived from the Java code generator by thomas

    begin                : Thur Jul 21 2005
    author               : Richard Dale
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2006-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#include "rubycodecomment.h"
#include <tqregexp.h>

// Constructors/Destructors
//

RubyCodeComment::RubyCodeComment(CodeDocument * doc, const TQString & text)
        : CodeComment(doc, text)
{

}

RubyCodeComment::~RubyCodeComment( ) { }

//
// Methods
//


// Accessor methods
//


// Public attribute accessor methods
//

// Other methods
//

TQString RubyCodeComment::getNewEditorLine( int amount ) {
    TQString line = getIndentationString(amount) + "# ";
    return line;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
TQString RubyCodeComment::unformatText(const TQString & text, const TQString & indent)
{
    // remove leading or trailing comment stuff
    TQString mytext = TextBlock::unformatText(text, indent);

    // now leading hash
    mytext.remove(TQRegExp("^#\\s*"));
    return mytext;
}

/**
 * @return    QString
 */
TQString RubyCodeComment::toString( )
{
    TQString output = "";

    // simple output method
    if (getWriteOutText()) {
        TQString indent = getIndentationString();
        TQString endLine = getNewLineEndingChars();
        output.append(formatMultiLineText(getText(), indent + "# ", endLine + endLine));
    }

    return output;
}


#include "rubycodecomment.moc"
