/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2007                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

// own header
#include "javacodedocumentation.h"

// qt/kde includes
#include <tqregexp.h>
#include <kdebug.h>

// local includes
#include "javaclassifiercodedocument.h"
#include "../codegenerationpolicy.h"
#include "../uml.h"

// Constructors/Destructors
//

JavaCodeDocumentation::JavaCodeDocumentation ( JavaClassifierCodeDocument * doc, const TQString & text )
        : CodeComment(doc, text)
{

}

JavaCodeDocumentation::~JavaCodeDocumentation ( ) { }

//
// Methods
//


// Accessor methods
//

// Other methods
//

/**
 * Save the XMI representation of this object
 */
void JavaCodeDocumentation::saveToXMI ( TQDomDocument & doc, TQDomElement & root ) {
    TQDomElement blockElement = doc.createElement( "javacodedocumentation" );
    setAttributesOnNode(doc, blockElement); // as we added no additional fields to this class we may
    // just use parent TextBlock method
    root.appendChild( blockElement );
}

/**
 * @return      QString
 */
TQString JavaCodeDocumentation::toString ( )
{

    TQString output = "";

    // simple output method
    if(getWriteOutText())
    {
        bool useDoubleDashOutput = true;

        // need to figure out output type from java policy
        CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
        if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
            useDoubleDashOutput = false;

        TQString indent = getIndentationString();
        TQString endLine = getNewLineEndingChars();
        TQString body = getText();
        if(useDoubleDashOutput)
        {
            if(!body.isEmpty())
                output.append(formatMultiLineText (body, indent +"// ", endLine));
        } else {
            output.append(indent+"/**"+endLine);
            output.append(formatMultiLineText (body, indent +" * ", endLine));
            output.append(indent+" */"+endLine);
        }
    }

    return output;
}

TQString JavaCodeDocumentation::getNewEditorLine ( int amount )
{
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
        return getIndentationString(amount) + " * ";
    else
        return getIndentationString(amount) + "// ";
}

int JavaCodeDocumentation::firstEditableLine() {
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
        return 1;
    return 0;
}

int JavaCodeDocumentation::lastEditableLine() {
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
    {
        return -1; // very last line is NOT editable
    }
    return 0;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
TQString JavaCodeDocumentation::unformatText ( const TQString & text , const TQString & indent)
{

    TQString mytext = TextBlock::unformatText(text, indent);
    CodeGenerationPolicy *p = UMLApp::app()->getCommonPolicy();
    // remove leading or trailing comment stuff
    mytext.remove(TQRegExp('^'+indent));
    if(p->getCommentStyle() == CodeGenerationPolicy::MultiLine)
    {
        mytext.remove(TQRegExp("^\\/\\*\\*\\s*\n?"));
        mytext.remove(TQRegExp("\\s*\\*\\/\\s*\n?$"));
        mytext.remove(TQRegExp("^\\s*\\*\\s*"));
    } else
        mytext.remove(TQRegExp("^\\/\\/\\s*"));

    return mytext;
}


#include "javacodedocumentation.moc"
