
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

#include "javacodecomment.h"
#include <tqregexp.h>

// Constructors/Destructors
//

JavaCodeComment::JavaCodeComment ( CodeDocument * doc, const TQString & text )
        : CodeComment (doc, text)
{

}

JavaCodeComment::~JavaCodeComment ( ) { }

//
// Methods
//


// Accessor methods
//


// Public attribute accessor methods
//

// Other methods
//

TQString JavaCodeComment::getNewEditorLine ( int amount ) {
    TQString line = getIndentationString(amount) + "// ";
    return line;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
TQString JavaCodeComment::unformatText ( const TQString & text , const TQString & indent)
{

    // remove leading or trailing comment stuff
    TQString mytext = TextBlock::unformatText(text, indent);

    // now leading slashes
    mytext.remove(TQRegExp("^\\/\\/\\s*"));
    return mytext;
}

/**
 * @return      QString
 */
TQString JavaCodeComment::toString ( )
{

    TQString output = "";

    // simple output method
    if(getWriteOutText())
    {
        TQString indent = getIndentationString();
        TQString endLine = getNewLineEndingChars();
        output.append(formatMultiLineText (getText(), indent +"// ", endLine));
    }

    return output;
}


#include "javacodecomment.moc"
