#ifndef PARSER_H
#define PARSER_H

#include <tqxml.h>
#include <tqmap.h>
#include <tqregexp.h>

struct BlockInfo {
    int start_line;
    int start_col;
    int end_line;
    int end_col;

    // used to detect sub-messages
    int offset;

    BlockInfo() {
        start_line = 0;
        start_col = 0;
        end_line = 0;
        end_col = 0;

        // used to detect sub-messages
        offset = 0;
    }
};

class MsgBlock {
 public:
    MsgBlock() { start = end = 0; do_not_split = false; }
    MsgBlock(const MsgBlock &rhs ) {
        *this = rhs;
    }
    TQValueList<BlockInfo> lines;
    TQString tag;
    TQString comment;
    TQString msgid;
    TQString msgid_plural;
    TQString msgstr;
    TQStringList msgstr_plurals;
    int start, end;
    bool do_not_split;

    void operator=(const MsgBlock& rhs) {
        lines = rhs.lines;
        tag = rhs.tag;
        comment = rhs.comment;
        msgid = rhs.msgid;
	msgid_plural = rhs.msgid_plural;
        msgstr = rhs.msgstr;
	msgstr_plurals = rhs.msgstr_plurals;
        start = rhs.start;
        end = rhs.end;
        do_not_split = rhs.do_not_split;
    }
};

class ParaCounter
{
public:
    ParaCounter() { current = 0; }
    void addAnchor(TQString anchor) { anchors.insert(anchor, current); }
    void increasePara() { current++; }

    TQMap<TQString, int> anchors;
    int current;
};

class MsgList : public TQValueList<MsgBlock>
{
public:
    MsgList() {}
    ParaCounter pc;
};

class StructureParser : public QXmlDefaultHandler
{
public:
    bool startDocument();
    bool startElement( const TQString&, const TQString&, const TQString& ,
                       const TQXmlAttributes& );
    bool endElement( const TQString&, const TQString&, const TQString& );
    bool characters( const TQString &ch);
    static bool isCuttingTag(const TQString &tag);
    static bool isSingleTag(const TQString &qName);
    static bool isLiteralTag(const TQString &qName);
    void setDocumentLocator ( TQXmlLocator * l ) { locator = l; }
    bool skippedEntity ( const TQString & name );
    bool fatalError ( const TQXmlParseException & );
    bool comment ( const TQString & );
    bool error(const TQXmlParseException &e ) { return fatalError(e); }
    bool warning(const TQXmlParseException &e ) { return fatalError(e); }
    MsgList getList() const { return list; }
    MsgList splitMessage(const MsgBlock &message);

    virtual bool startCDATA();
    virtual bool endCDATA();

    static bool closureTag(const TQString& message, const TQString &tag);
    static bool isClosure(const TQString &message);
    static void descape(TQString &message);
    static TQString escapeLiterals( const TQString &contents);
    static TQString descapeLiterals( const TQString &contents);
    static void cleanupTags( TQString &contents );
    static void removeEmptyTags( TQString &contents);
    static void stripWhiteSpace( TQString &contents);

private:
    bool formatMessage(MsgBlock &message) const;

    TQXmlLocator *locator;
    TQString message;
    int inside, startline, startcol;
    int line;
    MsgList list;
    mutable TQRegExp infos_reg;
    mutable TQRegExp do_not_split_reg;
};

void outputMsg(const char *prefix, const TQString &message);
MsgList parseXML(const char *filename);
TQString escapePO(TQString msgid);

#endif
