/***************************************************************************
                                diffhunk.h  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2003 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/

#ifndef DIFFHUNK_H
#define DIFFHUNK_H

#include "difference.h"

namespace Diff2
{

class Difference;

class DiffHunk
{
public:
	enum Type { Normal, AddedByBlend };

public:
	DiffHunk( int sourceLine, int destinationLine, TQString function = TQString::null, Type type = Normal );
	~DiffHunk();

	const DifferenceList& differences() const { return m_differences; };
	const TQString& function() const           { return m_function; };

	int sourceLineNumber() const      { return m_sourceLine; };
	int destinationLineNumber() const { return m_destinationLine; };

	int sourceLineCount() const;
	int destinationLineCount() const;

	const Type type() const   { return m_type; }
	void setType( Type type ) { m_type = type; }

	void add( Difference* diff );

	TQString recreateHunk() const;

private:
	int            m_sourceLine;
	int            m_destinationLine;
	DifferenceList m_differences;
	TQString        m_function;
	Type           m_type;
};

typedef TQValueList<DiffHunk*> DiffHunkList;
typedef TQValueList<DiffHunk*>::iterator DiffHunkListIterator;
typedef TQValueList<DiffHunk*>::const_iterator DiffHunkListConstIterator;

} // End of namespace Diff2

#endif
