/****************************************************************************
**
**
** Definition of TQSplitter class
**
**  Created : 980105
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
**********************************************************************/

#ifndef QSPLITTER_H
#define QSPLITTER_H

#ifndef QT_H
#include "tqframe.h"
#include "tqvaluelist.h"
#endif // QT_H

#ifndef QT_NO_SPLITTER


//class QSplitterHandle;
class QSplitterLayoutStruct;
class TQTextStream;

class QSplitterPrivate
{
public:
    QSplitterPrivate()
	: opaque( FALSE ), firstShow( TRUE ), childrenCollapsible( TRUE ),
	  handleWidth( 0 ) { }

    TQPtrList<QSplitterLayoutStruct> list;
    bool opaque : 8;
    bool firstShow : 8;
    bool childrenCollapsible : 8;
    int handleWidth;
};

class Q_EXPORT TQSplitter : public QFrame
{
    Q_OBJECT
    Q_PROPERTY( Orientation orientation READ orientation WRITE setOrientation )
    Q_PROPERTY( bool opaqueResize READ opaqueResize WRITE setOpaqueResize )
    Q_PROPERTY( int handleWidth READ handleWidth WRITE setHandleWidth )
    Q_PROPERTY( bool childrenCollapsible READ childrenCollapsible WRITE setChildrenCollapsible )

public:
    // ### Qt 4.0: remove Auto from public API
    enum ResizeMode { Stretch, KeepSize, FollowSizeHint, Auto };

    TQSplitter( TQWidget* parent = 0, const char* name = 0 );
    TQSplitter( Orientation, TQWidget* parent = 0, const char* name = 0 );
    ~TQSplitter();

    virtual void setOrientation( Orientation );
    Orientation orientation() const { return orient; }

    // ### Qt 4.0: make setChildrenCollapsible() and setCollapsible() virtual

    void setChildrenCollapsible( bool );
    bool childrenCollapsible() const;

    void setCollapsible( TQWidget *w, bool );
    virtual void setResizeMode( TQWidget *w, ResizeMode );
    virtual void setOpaqueResize( bool = TRUE );
    bool opaqueResize() const;

    void moveToFirst( TQWidget * );
    void moveToLast( TQWidget * );

    void refresh() { recalc( TRUE ); }
    TQSize sizeHint() const;
    TQSize minimumSizeHint() const;

    TQValueList<int> sizes() const;
    void setSizes( TQValueList<int> );

    int handleWidth() const;
    void setHandleWidth( int );

protected:
    void childEvent( TQChildEvent * );

    bool event( TQEvent * );
    void resizeEvent( TQResizeEvent * );

    int idAfter( TQWidget* ) const;

    void moveSplitter( QCOORD pos, int id );
    virtual void drawSplitter( TQPainter*, QCOORD x, QCOORD y,
			       QCOORD w, QCOORD h );
    void styleChange( TQStyle& );
    int adjustPos( int, int );
    virtual void setRubberband( int );
    void getRange( int id, int *, int * );

public: // private (:
    enum { DefaultResizeMode = 3 };

    void init();
    void recalc( bool update = FALSE );
    void doResize();
    void storeSizes();
    void getRange( int id, int *, int *, int *, int * );
    void addContribution( int, int *, int *, bool );
    int adjustPos( int, int, int *, int *, int *, int * );
    bool collapsible( QSplitterLayoutStruct * );
    void processChildEvents();
    QSplitterLayoutStruct *findWidget( TQWidget * );
    QSplitterLayoutStruct *addWidget( TQWidget *, bool prepend = FALSE );
    void recalcId();
    void doMove( bool backwards, int pos, int id, int delta, bool upLeft,
		 bool mayCollapse );
    void setGeo( TQWidget *w, int pos, int size, bool splitterMoved );
    int findWidgetJustBeforeOrJustAfter( int id, int delta, int &collapsibleSize );
    void updateHandles();

    inline QCOORD pick( const TQPoint &p ) const
    { return orient == Horizontal ? p.x() : p.y(); }
    inline QCOORD pick( const TQSize &s ) const
    { return orient == Horizontal ? s.width() : s.height(); }

    inline QCOORD trans( const TQPoint &p ) const
    { return orient == Vertical ? p.x() : p.y(); }
    inline QCOORD trans( const TQSize &s ) const
    { return orient == Vertical ? s.width() : s.height(); }

    QSplitterPrivate *d;

    Orientation orient;
    friend class QSplitterHandle;

#ifndef QT_NO_TEXTSTREAM
// moc doesn't like these.
//    friend Q_EXPORT TQTextStream& operator<<( TQTextStream&, const TQSplitter& );
//    friend Q_EXPORT TQTextStream& operator>>( TQTextStream&, TQSplitter& );
#endif

public:
#if defined(Q_DISABLE_COPY)
    TQSplitter( const TQSplitter & );
    TQSplitter& operator=( const TQSplitter & );
#endif
};

#ifndef QT_NO_TEXTSTREAM
Q_EXPORT TQTextStream& operator<<( TQTextStream&, const TQSplitter& );
Q_EXPORT TQTextStream& operator>>( TQTextStream&, TQSplitter& );
#endif

class QSplitterHandle : public QWidget
{
    Q_OBJECT
public:
    QSplitterHandle( Orientation o,
		     TQSplitter *parent, const char* name=0 );
    void setOrientation( Orientation o );
    Orientation orientation() const { return orient; }

    bool opaque() const { return s->opaqueResize(); }

    TQSize sizeHint() const;

    int id() const { return myId; } // d->list.at(id())->wid == this
    void setId( int i ) { myId = i; }

protected:
    void paintEvent( TQPaintEvent * );
    void mouseMoveEvent( TQMouseEvent * );
    void mousePressEvent( TQMouseEvent * );
    void mouseReleaseEvent( TQMouseEvent * );

public: // private (:
    Orientation orient;
    bool opaq;
    int myId;

    TQSplitter *s;
};

const uint Default = 2;

class QSplitterLayoutStruct : public Qt
{
public:
    QCOORD sizer;
    uint isHandle : 1;
    uint collapsible : 2;
    uint resizeMode : 2;
    TQWidget *wid;

    QSplitterLayoutStruct()
	: sizer( -1 ), collapsible( Default ) { }
    QCOORD getSizer( Orientation orient );
};

#endif // QT_NO_SPLITTER

#endif // QSPLITTER_H
