/* This file is part of KCachegrind.
   Copyright (C) 2003 Josef Weidendorfer <Josef.Weidendorfer@gmx.de>

   KCachegrind is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation, version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

/*
 * Source View
 */

#ifndef SOURCEVIEW_H
#define SOURCEVIEW_H

#include <tqlistview.h>
#include "traceitemview.h"

class SourceItem;

class SourceView : public TQListView, public TraceItemView
{
  friend class SourceItem;

  Q_OBJECT

public:
  SourceView(TraceItemView* parentView,
            TQWidget* parent = 0, const char* name = 0);

  TQWidget* widget() { return this; }
  TQString whatsThis() const;

protected:
  int arrowLevels() { return _arrowLevels; }
  void paintEmptyArea( TQPainter *, const TQRect & );

private slots:
  void context(TQListViewItem*, const TQPoint &, int);
  void selectedSlot(TQListViewItem *);
  void activatedSlot(TQListViewItem *);

private:
  TraceItem* canShow(TraceItem*);
  void doUpdate(int);
  void refresh();
  void updateJumpArray(uint,SourceItem*,bool,bool);
  void fillSourceFile(TraceFunctionSource*, int);
  void updateSourceItems();

  bool _inSelectionUpdate;

  // arrows
  int _arrowLevels;
  // temporary needed on creation...
  TQMemArray<TraceLineJump*> _jump;
  TraceLineJumpList _lowList, _highList;
};

#endif
