#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>

#include <kdebug.h>

#include "bugsystem.h"
#include "kbbprefs.h"

#include "severityselectdialog.h"
#include "severityselectdialog.moc"

SeveritySelectDialog::SeveritySelectDialog(TQWidget *parent,const char *name) :
  KDialogBase( parent, name, true, i18n("Select Severity"), Ok|Cancel )
{
    mButtonGroup = new TQButtonGroup( 1, Horizontal, i18n("Severity"), this );
    setMainWidget( mButtonGroup );

    TQValueList<Bug::Severity> severities = Bug::severities();
    TQValueList<Bug::Severity>::ConstIterator it;
    for( it = severities.begin(); it != severities.end(); ++it ) {
        mButtonGroup->insert(
            new TQRadioButton( Bug::severityToString( *it ), mButtonGroup ), int(*it) );
    }
}

void SeveritySelectDialog::setSeverity( Bug::Severity s )
{
    mButtonGroup->setButton( s );
}

Bug::Severity SeveritySelectDialog::selectedSeverity()
{
    return (Bug::Severity)mButtonGroup->id( mButtonGroup->selected() );
}

TQString SeveritySelectDialog::selectedSeverityAsString()
{
    return Bug::severityToString( selectedSeverity() );
}
