#include "serverconfigdialog.h"

#include "bugserverconfig.h"

#include <kpassdlg.h>
#include <kdebug.h>
#include <klocale.h>

#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqvbox.h>
#include <tqcombobox.h>

ServerConfigDialog::ServerConfigDialog( TQWidget *parent, const char *name ) :
  KDialogBase( parent, name, true, i18n("Edit Bugzilla Server"), Ok|Cancel )
{
  TQWidget *topFrame = makeMainWidget();

  TQGridLayout *topLayout = new TQGridLayout( topFrame );
  topLayout->setSpacing( spacingHint() );

  TQLabel *label;

  mServerName = new TQLineEdit( topFrame );
  label = new TQLabel( mServerName, i18n("Name:"), topFrame );
  topLayout->addWidget( label, 0, 0 );
  topLayout->addWidget( mServerName, 0, 1 );
  mServerName->setFocus();

  mServerUrl = new TQLineEdit( topFrame );
  label = new TQLabel( mServerUrl, i18n("URL:"), topFrame );
  topLayout->addWidget( label, 1, 0 );
  topLayout->addWidget( mServerUrl, 1, 1 );

  mUser = new TQLineEdit( topFrame );
  label = new TQLabel( mUser, i18n("User:"), topFrame );
  topLayout->addWidget( label, 2, 0 );
  topLayout->addWidget( mUser, 2, 1 );

  mPassword = new KPasswordEdit( topFrame );
  label = new TQLabel( mPassword, i18n("Password:"), topFrame );
  topLayout->addWidget( label, 3, 0 );
  topLayout->addWidget( mPassword, 3, 1 );

  mVersion = new TQComboBox( topFrame );
  label = new TQLabel( mVersion, i18n("Bugzilla version:"), topFrame );
  topLayout->addWidget( label, 4, 0 );
  topLayout->addWidget( mVersion, 4, 1 );
  mVersion->insertStringList( BugServerConfig::bugzillaVersions() );
}

void ServerConfigDialog::setServerConfig( const BugServerConfig &cfg )
{
  mServerName->setText( cfg.name() );
  mServerUrl->setText( cfg.baseUrl().url() );
  mUser->setText( cfg.user() );
  mPassword->setText( cfg.password() );

  int i;
  for( i = 0; i < mVersion->count(); ++i ) {
    if ( mVersion->text( i ) == cfg.bugzillaVersion() ) {
      mVersion->setCurrentItem( i );
      break;
    }
  }
}

BugServerConfig ServerConfigDialog::serverConfig()
{
  BugServerConfig cfg;

  cfg.setName( mServerName->text() );
  cfg.setBaseUrl( KURL( mServerUrl->text() ) );
  cfg.setUser( mUser->text() );
  cfg.setPassword( mPassword->text() );
  cfg.setBugzillaVersion( mVersion->currentText() );

  return cfg;
}

#include "serverconfigdialog.moc"
