#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <kdialogbase.h>

class TQCheckBox;
class TQRadioButton;
class TQLineEdit;
class TQListView;
class KIntNumInput;
class ServerListView;

class PreferencesDialog : public KDialogBase
{
    Q_OBJECT
  public:
    PreferencesDialog( TQWidget* parent = 0, const char* name = 0 );
    ~PreferencesDialog();

    void createServerItem( ServerListView *listView, const TQString &name,
                           const TQString &url, const TQString &version );

  public:
    void readConfig();
    void writeConfig();

  signals:
    void configChanged();

  protected slots:
    void setDefaults();
    void slotApply();
    void slotOk();
    void slotCancel();

    void addServer();
    void editServer();
    void removeServer();

    void selectServer();

  protected:
    void setupServerPage();
    void setupAdvancedPage();


  private:
    TQCheckBox *mShowClosedCheckBox;
    TQCheckBox *mShowWishesCheckBox;
    TQCheckBox *mShowVotedCheckBox;
    TQCheckBox *mSendBccCheckBox;
    KIntNumInput *mMinVotesInput;
    TQRadioButton *mKMailButton;
    TQRadioButton *mDirectButton;
    TQRadioButton *mSendmailButton;
    TQListView *mServerList;
};

class ServerListView;
class ServerItem;

class SelectServerDlg : public KDialogBase
{
    Q_OBJECT
public:
    SelectServerDlg(PreferencesDialog *parent, const char */*name*/ );
    ServerItem *serverSelected();
protected slots:
    void slotDoubleClicked( TQListViewItem *);

protected:
    ServerListView *list;
};


#endif
