/*
    cwsearchwidget.cpp  -  Search Pane

    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqpushbutton.h>
#include <klocale.h>
#include <kdialog.h>
#include <tqlineedit.h>
#include <tqlayout.h>
#include <kcombobox.h>
#include <tqlabel.h>

#include "cwsearchwidget.h"

using namespace KBugBusterMainWindow;

CWSearchWidget::CWSearchWidget( TQWidget *parent , const char * name )
: CWSearchWidget_Base( parent, name )
{
    // Set fonts and margins
    CWSearchWidget_BaseLayout->setSpacing( KDialog::spacingHint() );
    CWSearchWidget_BaseLayout->setMargin( KDialog::marginHint() );

    TQFont f = m_searchLabel->font();
    f.setBold( true );
    m_searchLabel->setFont( f );

    connect( m_searchDesc, TQT_SIGNAL( textChanged ( const TQString & ) ),
             this, TQT_SLOT( textDescriptionChanged ( const TQString & ) ) );

    connect( m_searchBugNumber, TQT_SIGNAL( textChanged ( const TQString & ) ),
             this, TQT_SLOT( textNumberChanged ( const TQString & ) ) );
             
    m_searchDescBtn->setEnabled( !m_searchDesc->text().isEmpty() );
    m_searchBugNumberBtn->setEnabled( !m_searchBugNumber->text().isEmpty() );

//    m_searchPackages->setCompletionMode( KGlobalSettings::CompletionAuto );
}

CWSearchWidget::~CWSearchWidget()
{
}

void CWSearchWidget::textDescriptionChanged ( const TQString &_text )
{
    m_searchDescBtn->setEnabled( !_text.isEmpty() );
}

void CWSearchWidget::textNumberChanged ( const TQString &_text )
{
    m_searchBugNumberBtn->setEnabled( !_text.isEmpty() );
}

#include "cwsearchwidget.moc"

/* vim: set et ts=4 sw=4 softtabstop=4: */

