/****************************************************************************
**
** This file is a modified version of part of an example program for Qt.
** This file may be used, distributed and modified without limitation.
**
** Don Sanders <sanders@kde.org>
**
*****************************************************************************/

#ifndef SMTP_H
#define SMTP_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqstringlist.h>

class TQSocket;
class TQTextStream;

class Smtp : public QObject
{
    Q_OBJECT

public:
    Smtp( const TQString &from, const TQStringList &to, const TQString &message, 
          const TQString &server, unsigned short int port = 25 );
    ~Smtp();
    void send( const TQString &, const TQStringList &, const TQString & );
    void quit();


signals:
    void success();
    void status( const TQString & );
    void error( const TQString &command, const TQString &response );

private slots:
    void readyRead();
    void connected();
    void deleteMe();
    void socketError(int err);
    void emitError();

private:
    enum State {
	smtpInit,
	smtpMail,
	smtpRcpt,
	smtpData,
	smtpBody,
	smtpSuccess,
	smtpQuit,
	smtpClose
    };

    TQString message;
    TQString from;
    TQStringList rcpt;
    TQSocket *mSocket;
    TQTextStream * t;
    int state;
    TQString response, responseLine;
    bool skipReadResponse;
    TQString command;
};

#endif
