#ifndef MAILSENDER_H
#define MAILSENDER_H

#include <tqstring.h>
#include <tqobject.h>

class KURL;
class Smtp;

class MailSender : public QObject
{
  Q_OBJECT
  public:
    enum MailClient { Sendmail = 0, KMail = 1, Direct = 2 };
  
    MailSender(MailClient,const TQString &smtpServer=TQString::null);
    virtual ~MailSender();

    MailSender *clone() const;

    /**
      Send mail with specified from, to and subject field and body as text. If
      bcc is set, send a blind carbon copy to the sender from.
      If recipient is specified the mail is sent to the specified address
      instead of 'to' . (this currently only works in for direct mail
      sending through SMTP.
    */
    bool send(const TQString &fromName, const TQString &fromEmail,
              const TQString &to,const TQString &subject,
              const TQString &body,bool bcc=false, 
              const TQString &recipient = TQString::null);

  signals:
    void status( const TQString &message );
    void finished();

  private slots:
    void smtpSuccess();
    void smtpError(const TQString &command, const TQString &response);

  private:
    int kMailOpenComposer(const TQString& arg0,const TQString& arg1,
                          const TQString& arg2,const TQString& arg3,
                          const TQString& arg4,int arg5,const KURL& arg6);

    MailClient m_client;
    TQString m_smtpServer;
};

#endif
