#ifndef QT_NO_ASCII_CAST
#define QT_NO_ASCII_CAST
#endif

#include <unistd.h>
#include <stdio.h>

#include <tqtimer.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <kurl.h>
#include <kapplication.h>
#include <dcopclient.h>
#include <kprocess.h>

#include "mailsender.h"
#include "smtp.h"

MailSender::MailSender(MailClient client,const TQString &smtpServer) :
  m_client( client ), m_smtpServer( smtpServer )
{
}

MailSender::~MailSender()
{
}

MailSender *MailSender::clone() const
{
  return new MailSender(m_client,m_smtpServer);
}

bool MailSender::send(const TQString &fromName,const TQString &fromEmail,const TQString &to,
                      const TQString &subject,const TQString &body,bool bcc,
                      const TQString &recipient)
{
  TQString from( fromName );
  if ( !fromEmail.isEmpty() )
    from += TQString::fromLatin1( " <%2>" ).arg( fromEmail );
  kdDebug() << "MailSender::sendMail():\nFrom: " << from << "\nTo: " << to
            << "\nbccflag:" << bcc
            << "\nRecipient:" << recipient
            << "\nSubject: " << subject << "\nBody: \n" << body << endl;

  // ### FIXME: bcc is not supported in direct mode and recipient is not
  // supported in sendmail and kmail mode

  if (m_client == Sendmail) {
    kdDebug() << "Sending per Sendmail" << endl;

    bool needHeaders = true;

    TQString command = KStandardDirs::findExe(TQString::fromLatin1("sendmail"),
        TQString::fromLatin1("/sbin:/usr/sbin:/usr/lib"));
    if (!command.isNull()) command += TQString::fromLatin1(" -oi -t");
    else {
      command = KStandardDirs::findExe(TQString::fromLatin1("mail"));
      if (command.isNull()) return false; // give up

      command.append(TQString::fromLatin1(" -s "));
      command.append(KProcess::quote(subject));

      if (bcc) {
        command.append(TQString::fromLatin1(" -b "));
        command.append(KProcess::quote(from));
      }

      command.append(" ");
      command.append(KProcess::quote(to));

      needHeaders = false;
    }

    FILE * fd = popen(command.local8Bit(),"w");
    if (!fd)
    {
      kdError() << "Unable to open a pipe to " << command << endl;
      TQTimer::singleShot( 0, this, TQT_SLOT( deleteLater() ) );
      return false;
    }

    TQString textComplete;
    if (needHeaders)
    {
      textComplete += TQString::fromLatin1("From: ") + from + '\n';
      textComplete += TQString::fromLatin1("To: ") + to + '\n';
      if (bcc) textComplete += TQString::fromLatin1("Bcc: ") + from + '\n';
      textComplete += TQString::fromLatin1("Subject: ") + subject + '\n';
      textComplete += TQString::fromLatin1("X-Mailer: KBugBuster") + '\n';
    }
    textComplete += '\n'; // end of headers
    textComplete += body;

    emit status( i18n( "Sending through sendmail..." ) );
    fwrite(textComplete.local8Bit(),textComplete.length(),1,fd);

    pclose(fd);
  } else if ( m_client == KMail ) {
    kdDebug() << "Sending per KMail" << endl;

    if (!kapp->dcopClient()->isApplicationRegistered("kmail")) {
      KMessageBox::error(0,i18n("No running instance of KMail found."));
      TQTimer::singleShot( 0, this, TQT_SLOT( deleteLater() ) );
      return false;
    }

    emit status( i18n( "Passing mail to KDE email program..." ) );
    if (!kMailOpenComposer(to,"", (bcc ? from : ""), subject,body,0,KURL())) {
      TQTimer::singleShot( 0, this, TQT_SLOT( deleteLater() ) );
      return false;
    }
  } else if ( m_client == Direct ) {
    kdDebug() << "Sending Direct" << endl;

    TQStringList recipients;
    if ( !recipient.isEmpty() )
        recipients << recipient;
    else
        recipients << to;

    TQString message = TQString::fromLatin1( "From: " ) + from +
                      TQString::fromLatin1( "\nTo: " ) + to +
                      TQString::fromLatin1( "\nSubject: " ) + subject +
                      TQString::fromLatin1( "\nX-Mailer: KBugBuster" ) +
                      TQString::fromLatin1( "\n\n" ) + body;

    Smtp *smtp = new Smtp( fromEmail, recipients, message, m_smtpServer );
    connect( smtp, TQT_SIGNAL( status( const TQString & ) ),
             this, TQT_SIGNAL( status( const TQString & ) ) );
    connect( smtp, TQT_SIGNAL( success() ),
             this, TQT_SLOT( smtpSuccess() ) );
    connect( smtp, TQT_SIGNAL( error( const TQString &, const TQString & ) ),
             this, TQT_SLOT( smtpError( const TQString &, const TQString & ) ) );

    smtp->insertChild( this ); // die when smtp dies
  } else {
    kdDebug() << "Invalid mail client setting." << endl;
  }

  if (m_client != Direct)
  {
    emit finished();
    TQTimer::singleShot( 0, this, TQT_SLOT( deleteLater() ) );
  }

  return true;
}

void MailSender::smtpSuccess()
{
  if ( parent() != sender() || !parent()->inherits( "Smtp" ) )
    return;

  static_cast<Smtp *>( parent() )->quit();
  emit finished();
}

void MailSender::smtpError(const TQString &_command, const TQString &_response)
{
  if ( parent() != sender() || !parent()->inherits( "Smtp" ) )
    return;

  TQString command = _command;
  TQString response = _response;

  Smtp *smtp = static_cast<Smtp *>( parent() );
  smtp->removeChild( this );
  delete smtp;

  KMessageBox::error( qApp->activeWindow(),
                      i18n( "Error during SMTP transfer.\n"
                            "command: %1\n"
                            "response: %2" ).arg( command ).arg( response ) );

  emit finished();
  TQTimer::singleShot( 0, this, TQT_SLOT( deleteLater() ) );
}

int MailSender::kMailOpenComposer(const TQString& arg0,const TQString& arg1,
  const TQString& arg2,const TQString& arg3,const TQString& arg4,int arg5,
  const KURL& arg6)
{
  int result = 0;

  TQByteArray data, replyData;
  TQCString replyType;
  TQDataStream arg( data, IO_WriteOnly );
  arg << arg0;
  arg << arg1;
  arg << arg2;
  arg << arg3;
  arg << arg4;
  arg << arg5;
  arg << arg6;
  if (kapp->dcopClient()->call("kmail","KMailIface","openComposer(TQString,TQString,TQString,TQString,TQString,int,KURL)", data, replyType, replyData ) ) {
    if ( replyType == "int" ) {
      TQDataStream _reply_stream( replyData, IO_ReadOnly );
      _reply_stream >> result;
    } else {
      kdDebug() << "kMailOpenComposer() call failed." << endl;
    }
  } else {
    kdDebug() << "kMailOpenComposer() call failed." << endl;
  }
  return result;
}

#include "mailsender.moc"

