
#include "bugjob.h"

#include "kbbprefs.h"

#include <kio/job.h>

#include <string.h>
#include <klocale.h>
#include <kdebug.h>

BugJob::BugJob( BugServer *server )
    : Job( false ), mServer( server )
{
}

BugJob::~BugJob()
{
}

void BugJob::start( const KURL &url )
{
    kdDebug() << "BugJob::start(): " << url.url() << endl;

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveQuery( url );
    }

    // ### obey post, if necessary

    KIO::Job *job = KIO::get( url, true /*always 'reload=true', we have our own cache*/, false );

    connect( job, TQT_SIGNAL( result( KIO::Job * ) ),
             this, TQT_SLOT( ioResult( KIO::Job * ) ) );
    connect( job, TQT_SIGNAL( data( KIO::Job *, const TQByteArray & ) ),
             this, TQT_SLOT( ioData( KIO::Job *, const TQByteArray & ) ) );
    connect( job, TQT_SIGNAL( infoMessage( KIO::Job *, const TQString & ) ),
             this, TQT_SLOT( ioInfoMessage( KIO::Job *, const TQString & ) ) );
    connect( job, TQT_SIGNAL( percent( KIO::Job *, unsigned long ) ),
             this, TQT_SLOT( ioInfoPercent( KIO::Job *, unsigned long ) ) );
}

void BugJob::ioResult( KIO::Job *job )
{
    m_error = job->error();
    m_errorText = job->errorText();

    if ( job->error() )
    {
        emit error( m_errorText );
        BugSystem::self()->unregisterJob(this);
        this->kill();
        return;
    }

    infoMessage( i18n( "Parsing..." ) );

#if 0
    kdDebug() << "--START:" << m_data << ":END--" << endl;
#endif

    if ( KBBPrefs::instance()->mDebugMode ) {
        BugSystem::saveResponse( m_data );
    }

    process( m_data );
    infoMessage( i18n( "Ready." ) );

    emit jobEnded( this );

    delete this;
}

void BugJob::ioData( KIO::Job *, const TQByteArray &data )
{
    unsigned int start = m_data.size();

    m_data.resize( m_data.size() + data.size() );
    memcpy( m_data.data() + start, data.data(), data.size() );
}

void BugJob::ioInfoMessage( KIO::Job *, const TQString &_text )
{
    TQString text = _text;
    emit infoMessage( text );
}

void BugJob::ioInfoPercent( KIO::Job *, unsigned long percent )
{
    emit infoPercent( percent );
}

#include "bugjob.moc"

/*
 * vim:sw=4:ts=4:et
 */
