#ifndef __bugdetails_h__
#define __bugdetails_h__

#include "person.h"
#include "bugdetailspart.h"
#include "bugdetailsimpl.h"

#include <tqvaluelist.h>

#include <ksharedptr.h>

class BugDetailsImpl;

class BugDetails
{
public:
    typedef TQValueList<BugDetails> List;
    struct Attachment {
        TQByteArray contents;
        TQString filename;
    };

    BugDetails();
    BugDetails( BugDetailsImpl *impl );
    BugDetails( const BugDetails &other );
    BugDetails &operator=( const BugDetails &rhs );
    ~BugDetails();

    TQString version() const;
    TQString source() const;
    TQString compiler() const;
    TQString os() const;
    BugDetailsPart::List parts() const;
    void addAttachmentDetails( const TQValueList<BugDetailsImpl::AttachmentDetails>& attch );
    TQValueList<BugDetailsImpl::AttachmentDetails> attachmentDetails() const;
    TQValueList<BugDetails::Attachment> extractAttachments() const;
    static TQValueList<BugDetails::Attachment> extractAttachments( const TQString& text );

    TQDateTime submissionDate() const;
    int age() const;

    bool operator==( const BugDetails &rhs );

    bool isNull() const { return m_impl == 0; }

private:
    BugDetailsImpl *impl() const { return m_impl; }

    KSharedPtr<BugDetailsImpl> m_impl;
};

#endif

/* vim: set sw=4 ts=4 et softtabstop=4: */

