/*
 *
 * $Id: kbabelsplash.cpp 1157652 2010-07-31 19:51:49Z tpearson $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *               2003 Stanislav Visnovsky <visnovsky@kde.org>
 *
 * This file is part of the KBabel project. It's taken from the K3b project,
 * Copyright (C) 1998-2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the Qt library by Trolltech AS, Norway (or with modified versions
  of Qt that use the same license as Qt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  Qt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

 */

#include "kbabelsplash.h"

#include <tqapplication.h>
#include <tqlabel.h>
#include <tqpixmap.h>
#include <tqevent.h>
#include <tqstring.h>
#include <tqfontmetrics.h>
#include <tqpainter.h>

#include <kstandarddirs.h>

KBabelSplash* KBabelSplash::instance = 0;

KBabelSplash::KBabelSplash( TQWidget* parent, const char* name )
  : TQVBox( parent, name, WType_Dialog|WShowModal|WStyle_Customize|WStyle_NoBorder|WDestructiveClose )
{
  setMargin( 0 );
  setSpacing( 0 );

  TQLabel* picLabel = new TQLabel( this );
  TQPixmap pixmap;
  if( pixmap.load( locate( "data", "kbabel/pics/splash.png" ) ) )
    picLabel->setPixmap( pixmap );

  picLabel->setFrameStyle(TQFrame::WinPanel | TQFrame::Raised);

  // Set geometry, with support for Xinerama systems
  TQRect r;
  r.setSize(sizeHint());
  int ps = TQApplication::desktop()->primaryScreen();
  r.moveCenter( TQApplication::desktop()->screenGeometry(ps).center() );
  setGeometry(r);

  delete instance;
  instance = this;
}


void KBabelSplash::mousePressEvent( TQMouseEvent* )
{
  close();
}

#include "kbabelsplash.moc"
