/* This file is part of KBabel
   Copyright (C) 2002 Stanislav Visnovsky <visnovsky@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

   In addition, as a special exception, the copyright holders give
   permission to link the code of this program with any edition of
   the Qt library by Trolltech AS, Norway (or with modified versions
   of Qt that use the same license as Qt), and distribute linked
   combinations including the two.  You must obey the GNU General
   Public License in all respects for all of the code used other than
   Qt. If you modify this file, you may extend this exception to
   your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
   your version.
  
*/

#include "toolaction.h"

#include <kdebug.h>

ToolAction::ToolAction( const TQString & text, const KShortcut& cut, const KDataToolInfo & info, const TQString & command,
                                    TQObject * parent, const char * name )
  : KAction( text, info.iconName() == "unknown" ? TQString::null : info.iconName(), cut, parent, name ),
      m_command( command ),
      m_info( info )
{
}

void ToolAction::slotActivated()
{
    emit toolActivated( m_info, m_command );
}

TQPtrList<KAction> ToolAction::dataToolActionList( const TQValueList<KDataToolInfo> & tools, const TQObject *receiver, const char* slot, const TQStringList& command, bool excludeCommand, KActionCollection* parent, const TQString& namePrefix )
{
    TQPtrList<KAction> actionList;
    if ( tools.isEmpty() )
	return actionList;
	
    TQValueList<KDataToolInfo>::ConstIterator entry = tools.begin();
    for( ; entry != tools.end(); ++entry )
    {
	TQStringList userCommands = (*entry).userCommands();
	TQStringList commands = (*entry).commands();
	TQStringList shortcuts = (*entry).service()->property("Shortcuts").toStringList();
	Q_ASSERT(!commands.isEmpty());
	if ( commands.count() != userCommands.count() )
	        kdWarning() << "KDataTool desktop file error (" << (*entry).service()
	        << "). " << commands.count() << " commands and "
	        << userCommands.count() << " descriptions." << endl;
	
	TQStringList::ConstIterator uit = userCommands.begin();
	TQStringList::ConstIterator cit = commands.begin();
	TQStringList::ConstIterator sit = shortcuts.begin();
	for (; uit != userCommands.end() && cit != commands.end(); ++uit, ++cit)
	{
	    if( !excludeCommand == command.contains(*cit) )
	    {
		TQString sc=*sit;

		ToolAction * action = new ToolAction( *uit, (sc.isEmpty()?TQString::null:sc), *entry, *cit
		    , parent
		    , TQString(namePrefix+(*entry).service()->library()+"_"+(*cit)).utf8() );
		connect( action, TQT_SIGNAL( toolActivated( const KDataToolInfo &, const TQString & ) ),
                     receiver, slot );
		
        	actionList.append( action );
	    }
	    if( sit != shortcuts.end() ) sit++;
        }
    }

    return actionList;
}

TQValueList<KDataToolInfo> ToolAction::validationTools()
{
    TQValueList<KDataToolInfo> result;
    
    TQValueList<KDataToolInfo> tools = KDataToolInfo::query("CatalogItem", "application/x-kbabel-catalogitem", KGlobal::instance());
    
    for( TQValueList<KDataToolInfo>::ConstIterator entry = tools.begin(); entry != tools.end(); ++entry )
    {
	if( (*entry).commands().contains("validate") ) 
	{
	    result.append( *entry );
	}
    }
    
    return result;
}

#include "toolaction.moc"
