//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMLISTPATTERNEDIT_H
#define PMLISTPATTERNEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmdialogeditbase.h"

class PMListPattern;
class PMVectorEdit;
class TQComboBox;
class PMFloatEdit;
class TQLabel;

/**
 * Dialog edit class for @ref PMListPattern.
 */
class PMListPatternEdit : public PMDialogEditBase
{
   Q_OBJECT
   typedef PMDialogEditBase Base;
public:
   /**
    * Creates a PMListPatternEdit with parent and name
    */
   PMListPatternEdit( TQWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

protected slots:
   /**
    * This slot is called when the list type is changed
    */
   void slotComboChanged( int c );

private:
   PMListPattern*  m_pDisplayedObject;
   TQComboBox*      m_pTypeCombo;
   PMFloatEdit*    m_pMortar;
   PMVectorEdit*   m_pBrickSize;
   TQLabel*         m_pBrickSizeLabel;
   TQLabel*         m_pMortarLabel;

   TQLabel*         m_pDepthLabel;
   PMFloatEdit*    m_pDepth;
};


#endif
