// Qt# tutorial 6
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class LCDRange : TQVBox {

	public LCDRange (TQWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		TQLCDNumber lcd = new TQLCDNumber (2, this, "lcd" );
		TQSlider slider = new TQSlider (Orientation.Horizontal, this, "slider");
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, TQT_SIGNAL ("valueChanged(int)"), lcd, TQT_SLOT ("Display(int)") );
	}
	
	public LCDRange (TQWidget parent) : this (parent, "") {}
	public LCDRange () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class MyWidget : TQVBox {

	MyWidget (TQWidget parent, String name) : base (parent, name)
	{
		TQPushButton quit = new TQPushButton ("Quit", this, "quit");
		quit.SetFont ( new TQFont ("Times", 18, TQFont.Weight.Bold) );
		
		Connect ( quit, TQT_SIGNAL ("clicked()"), qApp, TQT_SLOT ("Quit()") );
		
		TQGrid grid = new TQGrid (4, this);
		
		for ( int c =0; c < 4; c++ )
			for ( int r = 0; r < 4; r++ )
				new LCDRange (grid);
	}
	
	public MyWidget (TQWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
}

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);

		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
