/***************************************************************************
                          JavaSlot.h  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lost Highway Ltd reserves the right to issue additional license types *
 *   compatible with the Trolltech AS Qt commercial license.               *
 ***************************************************************************/

#ifndef _JAVASLOT_H_
#define _JAVASLOT_H_

#include <jni.h>
#include <tqobject.h>

#include <tqevent.h>
#include <tqlistview.h>
#include <tqiconview.h>
#include <tqlistbox.h>
#include <tqdatetime.h>
#include <tqtoolbar.h>
#include <tqaction.h>
#include <tqnetworkprotocol.h>
#include <tqsql.h>
#include <tqsqlcursor.h>
#include <tqsqlrecord.h>
#include <tqurlinfo.h>
#include <tqlibrary.h>
#include <tqhttp.h>
#include <tqdir.h>
#include <tqtextedit.h>

class JavaSlotFactory;
class QMetaObject;

class JavaSlot: public QObject
{
    Q_OBJECT
public:
    JavaSlot(JNIEnv * env, jobject receiver, jstring slot);
    ~JavaSlot();
	
	/** Set the JavaSlot factory to create any JavaSlot instances */
	static void setJavaSlotFactory(JavaSlotFactory * factory);

    /** Return a new JavaSlot instance via the JavaSlot factory */
	static JavaSlot * createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);

	/** Given a Java signal name, returns the corresponding C++ signal name.
		The TQMetaObject is used to check whether the TQObject instance described
		by 'smeta' implements the C++ signal. */
	const char * javaToQtSignalName(JNIEnv * env, jstring signalString, TQMetaObject * smeta);
	
	/** Converts a Java type signature for a signal to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSignalType(const char * signalName, const char * javaTypeSignature, TQMetaObject * smeta);

	/** Given a Java slot name, returns the corresponding C++ slot name. The optional signalString
		parameter is the C++ signal to connect to - any C++ slot type signature must match this.
	*/
	const char * javaToQtSlotName(JNIEnv * env, jstring slotString, const char * signalString = 0);

	/** Converts a Java type signature for a slot to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSlotType(const char * javaTypeSignature, const char * signalString);

public slots:
    void invoke();
    void invoke(bool arg);
	void invoke(bool* arg1, bool* arg2);
    void invoke(char arg);
    void invoke(double arg);
    void invoke(float arg);
    void invoke(int arg);
    void invoke(int arg1, bool arg2);
    void invoke(int arg1,const TQCString& arg2,const TQByteArray& arg3);
    void invoke(int arg1,const TQPoint& arg2);
    void invoke(int arg1,const TQString& arg2);
    void invoke(int arg1,int arg2);
    void invoke(int arg1,int arg2,const TQPoint& arg3);
	void invoke(int arg1,int arg2,int arg3);
	void invoke(int arg1,int arg2,int arg3,const TQPoint& arg4);
	void invoke(int arg1,int arg2,TQNetworkOperation* arg3);
	void invoke(int arg1,TQDropEvent* arg2);
	void invoke(int arg1,TQIconViewItem* arg2,const TQPoint& arg3);
	void invoke(int arg1,TQListBoxItem* arg2,const TQPoint arg3);
	void invoke(int arg1,TQListViewItem* arg2,const TQPoint arg3,int arg4);
    void invoke(long arg);
    void invoke(long arg,const TQByteArray&);
    void invoke(long arg,const TQString&);
    void invoke(short arg);
    void invoke(unsigned char arg);
	void invoke(TQAction * arg1);
	void invoke(TQDir::SortSpec arg1);
	void invoke(TQDockWindow * arg1);
	void invoke(TQDockWindow::Place arg1);
	void invoke(TQDropEvent* arg1);
	void invoke(TQDropEvent* arg1,TQListViewItem*arg2);
	void invoke(TQDropEvent* arg1,const TQValueList<TQIconDragItem>& arg2);
	void invoke(TQDropEvent*arg1,TQListViewItem*arg2,TQListViewItem*arg3);
	void invoke(TQIconViewItem* arg1);
	void invoke(TQIconViewItem* arg1,const TQPoint& arg2);
	void invoke(TQIconViewItem* arg1,const TQString& arg2);
	void invoke(QList<TQListViewItem> arg1,QList<TQListViewItem> arg2,QList<TQListViewItem> arg3);
	void invoke(TQListBoxItem* arg1);
	void invoke(TQListBoxItem* arg1,const TQPoint& arg2);
	void invoke(TQListViewItem* arg1, int arg2, const TQString& arg3);
	void invoke(TQListViewItem* arg1,TQListViewItem*arg2,TQListViewItem*arg3);
	void invoke(TQListViewItem* arg1,const TQPoint& arg2,int arg3);
	void invoke(TQListViewItem* arg1,const TQString& arg2,int arg3);
	void invoke(TQListViewItem* arg1,int arg2);
	void invoke(TQListViewItem*arg1);
	void invoke(TQNetworkOperation* arg1);
	void invoke(TQObject* arg1);
	void invoke(TQPopupMenu* arg1);
	void invoke(TQSql::Op arg1);
	void invoke(TQSqlCursor::Mode arg1);
	void invoke(TQSqlRecord* arg1);
	void invoke(TQTextEdit::VerticalAlignment arg1);
	void invoke(TQToolBar* arg1);
	void invoke(Orientation arg1);
	void invoke(TQWidget* arg1);
	void invoke(TQWidget* arg1,const TQPoint& arg2);
	void invoke(TQWidget* arg1,const TQString& arg2);
	void invoke(TQWidget* arg1,const TQDropEvent* arg2);
	void invoke(TQWidget* arg1,TQPixmap arg2);
	void invoke(const TQByteArray& arg1);
	void invoke(const TQByteArray& arg1,TQNetworkOperation* arg2);
	void invoke(const char* arg1, bool arg2);
	void invoke(const char* arg1,const TQString& arg2,const TQByteArray& arg3,const TQString& arg4,const TQString& arg5,const TQString& arg6);
	void invoke(const TQChar& arg1);
	void invoke(const TQCString& arg1);
	void invoke(const TQColor& arg1);
	void invoke(const TQColor& arg1,const TQString& arg2);
	void invoke(const TQDate& arg1);
	void invoke(const TQDate& arg1,const TQDate& arg2);
	void invoke(const TQDateTime& arg1);
	void invoke(const TQDragMoveEvent* arg1,bool& arg2);
	void invoke(const TQSize& arg1);
	void invoke(const TQFont& arg1);
	void invoke(const TQHttpResponseHeader& arg1);
	void invoke(const TQImage& arg1, int arg2);
	void invoke(const TQPixmap& arg1);
	void invoke(const TQPoint& arg1);
	void invoke(const TQRect& arg1);
	void invoke(const TQSqlRecord* arg1);
	void invoke(const TQString& arg1);
	void invoke(const TQString& arg1,bool arg2,const TQString& arg3);
	void invoke(const TQString& arg1,const TQCString& arg2,const TQString& arg3);
	void invoke(const TQString& arg1,TQLibrary* arg2);
	void invoke(const TQString& arg1,const TQPoint& arg2);
	void invoke(const TQString& arg1,const TQString& arg2);
	void invoke(const TQString& arg1,const TQStringList& arg2,unsigned int arg3);
	void invoke(const TQString& arg1,const TQString& arg2,unsigned int arg3);
	void invoke(const TQString& arg1,int arg2);
	void invoke(const TQString& arg1,int arg2,int arg3);
	void invoke(const TQString& arg1,int arg2,int arg3,int arg4);
	void invoke(const TQStringList& arg1);
	void invoke(const TQTime& arg1);
	void invoke(const TQString& arg1,unsigned long arg2,unsigned long arg3,unsigned long arg4);
	void invoke(const TQUrlInfo& arg1);
	void invoke(const TQUrlInfo& arg1,TQNetworkOperation* arg2);
	void invoke(const TQValueList<TQUrlInfo>& arg1,TQNetworkOperation* arg2);
	void invoke(const TQVariant& arg1);
	void invoke(const unsigned long& arg1,const unsigned long& arg2,const unsigned long& arg3,const TQString& arg4);
	
    /** Java signals are always of type 'jobjectArray' */
	void invoke(jobjectArray args);

protected:
    jobject invocation;
private:
    static JavaSlotFactory *	_factory;
};

class JavaSlotFactory {
public:
	JavaSlotFactory();
	virtual ~JavaSlotFactory() {};
	virtual JavaSlot *	createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);
};

class JavaSignal: public QObject
{
    Q_OBJECT
public:
    JavaSignal();
    ~JavaSignal();
    void emitArgs(jobjectArray args);
signals:
    void signalJava(jobjectArray);
};

#endif




